/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.ValidateDuoTokenAuthenticationResult;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateDuoTokenAuthenticationResultTest
extends AbstractDuoActionTest {
    private ValidateDuoTokenAuthenticationResult action;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new ValidateDuoTokenAuthenticationResult();
    }

    @Test
    public void testExecuteSuccess() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    public void testExecuteNoAuthResult() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyTokenNoAuthResult("DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteNoAuthStatus() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyTokenNoResultStatus("Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteNoAuthContextFactor() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyTokenNoAuthFactor("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    public void testNoDuoContext() throws ComponentInitializationException {
        this.addAttemptedFlow("authn/DuoOIDC");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidAuthenticationContext");
    }

    @Test
    public void testExecuteRequestDenied() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        HashMap<String, List<String>> classifiedMessages = new HashMap<String, List<String>>();
        classifiedMessages.put("AccountLocked", Arrays.asList("deny"));
        this.action.setClassifiedMessages(classifiedMessages);
        this.dc.setAuthToken(this.createPlainDummyToken("deny", "Account locked", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AccountLocked");
    }

    @Test
    public void testExecuteNoDuoAuthToken() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidAuthenticationContext");
    }

    @Test
    public void testExecuteFailedToken() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("deny", "Login Failed", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidCredentials");
    }

    @Test
    public void testExecuteWithPrincipalHook() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.setContextToPrincipalMappingStrategy(prc -> {
            DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class);
            ArrayList<AuthnContextClassRefPrincipal> p = new ArrayList<AuthnContextClassRefPrincipal>();
            try {
                if ("duo_push".equals(duoContext.getAuthToken().getJWTClaimsSet().getJSONObjectClaim("auth_context").get("factor"))) {
                    p.add(new AuthnContextClassRefPrincipal("http://example.com/duoPush"));
                }
            }
            catch (ParseException e) {
                throw new RuntimeException("Can not find duo factor in mocked duo response", e);
            }
            return p;
        });
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
        Assert.assertNotNull((Object)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getAuthenticationResult());
        Subject sbj = ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getAuthenticationResult().getSubject();
        Assert.assertTrue((boolean)sbj.getPrincipals().contains(new AuthnContextClassRefPrincipal("http://example.com/duoPush")));
    }

    @Test
    public void testExecuteWithPrincipalHookNoMatchingFactor() throws ComponentInitializationException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.addAttemptedFlow("authn/DuoOIDC");
        this.dc.setAuthToken(this.createPlainDummyToken("allow", "Login Succesful", "DIU6GEFWG5LIUBVV2M3P", Instant.now().plus(1L, ChronoUnit.MINUTES), Instant.now(), Instant.now(), "api.duosecurity.com", "duo_push"));
        this.dc.setUsername("jdoe");
        this.action.setContextToPrincipalMappingStrategy(prc -> {
            DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)((AuthenticationContext)prc.getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class);
            ArrayList<AuthnContextClassRefPrincipal> p = new ArrayList<AuthnContextClassRefPrincipal>();
            try {
                if ("sms".equals(duoContext.getAuthToken().getJWTClaimsSet().getJSONObjectClaim("auth_context").get("factor"))) {
                    p.add(new AuthnContextClassRefPrincipal("http://example.com/sms"));
                }
            }
            catch (ParseException e) {
                throw new RuntimeException("Can not find duo factor in mocked duo response", e);
            }
            return p;
        });
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
        Assert.assertNotNull((Object)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getAuthenticationResult());
        Subject sbj = ((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getAuthenticationResult().getSubject();
        Assert.assertFalse((boolean)sbj.getPrincipals().contains(new AuthnContextClassRefPrincipal("http://example.com/sms")));
    }
}

