/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.idp.plugin.authn.duo.SimpleDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.PopulateDuoAuthenticationContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateDuoAuthenticationContextTest
extends AbstractDuoActionTest {
    private PopulateDuoAuthenticationContext action;
    private MockHttpServletRequest request;

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.action = new PopulateDuoAuthenticationContext();
        this.request = new MockHttpServletRequest();
    }

    @Test
    public void testExecuteSuccessWithStaticClient() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        SimpleDuoOIDCIntegration integ = new SimpleDuoOIDCIntegration();
        integ.setAPIHost("api.duosecurity.com");
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setRedirectURI("https://simple-static.redirect/");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        integ.setAuthorizeEndpoint("/authorize");
        integ.setTokenEndpoint("/token");
        integ.setHealthCheckEndpoint("/health");
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        DuoOIDCClient mockClient = (DuoOIDCClient)Mockito.mock(DuoOIDCClient.class);
        Mockito.when((Object)mockClientRegistry.getClientOrCreate((DuoOIDCIntegration)ArgumentMatchers.any(DuoOIDCIntegration.class))).thenReturn((Object)mockClient);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
        Assert.assertEquals((String)((DuoOIDCAuthenticationContext)this.ac.getSubcontext(DuoOIDCAuthenticationContext.class)).getRedirectURIOverride(), null);
    }

    @Test
    public void testExecuteDynamicClientButNoRedirectCreationStrategy() throws ComponentInitializationException, DuoRegistryException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.request.addHeader("Host", (Object)"example.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        DuoOIDCClient mockClient = (DuoOIDCClient)Mockito.mock(DuoOIDCClient.class);
        Mockito.when((Object)mockClientRegistry.getClientOrCreate((DuoOIDCIntegration)ArgumentMatchers.any(DuoOIDCIntegration.class))).thenReturn((Object)mockClient);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteSuccessWithDynamicClient() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        integ.setRegisteredRedirectURI(null);
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        this.request.addHeader("Host", (Object)"example.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        DuoOIDCClient mockClient = (DuoOIDCClient)Mockito.mock(DuoOIDCClient.class);
        Mockito.when((Object)mockClientRegistry.getClientOrCreate((DuoOIDCIntegration)ArgumentMatchers.any(DuoOIDCIntegration.class))).thenReturn((Object)mockClient);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)event);
        Assert.assertEquals((String)integ.getRedirectURI(), (String)"https://example.com/idp/profile/Authn/Duo/2FA/callback");
        Assert.assertEquals((String)((DuoOIDCAuthenticationContext)this.ac.getSubcontext(DuoOIDCAuthenticationContext.class)).getRedirectURIOverride(), (String)"https://example.com/idp/profile/Authn/Duo/2FA/callback");
    }

    @Test
    public void testExecuteNoDuoIntegration() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidProfileContext");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testExecuteNoDuoClientRegistry() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        this.action.initialize();
    }

    @Test
    public void testExecuteNullUsername() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> null);
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "NoCredentials");
    }

    @Test
    public void testExecuteNullRedirectURI() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> null);
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteClientException() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        Mockito.when((Object)mockClientRegistry.getClientOrCreate((DuoOIDCIntegration)ArgumentMatchers.any(DuoOIDCIntegration.class))).thenThrow(DuoRegistryException.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    public void testExecuteNoHttpRequest() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidProfileContext");
    }

    @Test
    public void testExecuteNoDuoContext() throws ComponentInitializationException, DuoRegistryException, DuoClientException {
        DefaultDuoOIDCIntegration integ = this.createDummyDuoIntegration();
        this.action.setDuoIntegrationLookupStrategy(prc -> integ);
        this.action.setUsernameLookupStrategy(prc -> "jdoe");
        this.action.setRedirectURICreationStrategy((http, duoInteg) -> "https://example.com/idp/profile/Authn/Duo/2FA/callback");
        this.action.setDuoContextCreationStrategy(prc -> null);
        this.action.setHttpServletRequest((HttpServletRequest)this.request);
        DuoOIDCClientRegistry mockClientRegistry = (DuoOIDCClientRegistry)Mockito.mock(DuoOIDCClientRegistry.class);
        this.action.setClientRegistry(mockClientRegistry);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        this.assertEventId(event, "InvalidProfileContext");
    }
}

