/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoUsernameClaimLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DuoUsernameClaimLookupStrategyTest
extends AbstractDuoActionTest {
    @Nonnull
    private DuoUsernameClaimLookupStrategy strategy;

    @BeforeMethod
    public void beforeMethod() throws ComponentInitializationException {
        super.setup();
        this.strategy = new DuoUsernameClaimLookupStrategy();
    }

    @Test
    public void applySuccess() {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setUsername("username");
        String username = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)username, (String)"username");
    }

    @Test
    public void applyNoUsername() {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setUsername(null);
        String username = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)username, null);
    }

    @Test
    public void applyNoDuoContext() {
        String username = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)username, null);
    }
}

