/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.ExternalAuthenticationImpl;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoOIDCAuthnController;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_OK;
import net.shibboleth.idp.plugin.authn.util.mock.IdPPropertyConfigurer;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import org.apache.commons.codec.binary.Hex;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.NestedServletException;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(classes={DuoOIDCAuthnController.class, IdPPropertyConfigurer.class})
@WebAppConfiguration
@TestPropertySource(properties={"idp.authn.duo.OIDC.externalAuthnPath=/Authn/Duo/2FA"})
public class DuoOIDCAuthnControllerTest
extends AbstractTestNGSpringContextTests {
    @Nonnull
    private final String API_HOST = "duo.host.com";
    @Nonnull
    private final String KEY = "e1s1";
    @Nonnull
    private final String NONCE = "8821febf7b3237fc3974f76a75f37e8c";
    @NonnullAfterInit
    private String state;
    @Nonnull
    private final String CODE = "db87f45083db5aea16eb45b7ace685c8";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoOIDCAuthnControllerTest.class);
    @Nonnull
    private MockMvc mockMvc;
    @Nonnull
    @Autowired
    private ServletContext servletContext;
    @Nonnull
    @Autowired
    private WebApplicationContext webApplicationContext;

    @BeforeMethod
    public void setUp() throws Exception {
        this.state = "8821febf7b3237fc3974f76a75f37e8c." + Hex.encodeHexString((byte[])"e1s1".getBytes());
        DuoOIDCAuthnController controller = (DuoOIDCAuthnController)this.webApplicationContext.getBean(DuoOIDCAuthnController.class);
        Assert.assertNotNull((Object)controller);
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
        this.exportServletContextAttributes();
    }

    @Test
    public void testSuccessfulAuthorizeRequest() throws Exception {
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/authorize", (Object[])new Object[0]).param("conversation", new String[]{"e1s1"})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andReturn();
        Assert.assertNotNull((Object)result.getResponse().getHeader("Location"));
        Assert.assertTrue((boolean)result.getResponse().getHeader("Location").contains("duo.host.com"));
    }

    @Test
    public void testIncorrectStateNoExecutionKey() throws Exception {
        try {
            String invalidState = "8821febf7b3237fc3974f76a75f37e8c.";
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("code", new String[]{"db87f45083db5aea16eb45b7ace685c8"}).param("state", new String[]{"8821febf7b3237fc3974f76a75f37e8c."})).andDo(MockMvcResultHandlers.print());
        }
        catch (NestedServletException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ExternalAuthenticationException));
            this.log.error("{}", (Object)e.getRootCause().getMessage());
        }
    }

    @Test
    public void testIncorrectStateNoNonce() throws Exception {
        try {
            String invalidState = ".e1s1";
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("code", new String[]{"db87f45083db5aea16eb45b7ace685c8"}).param("state", new String[]{".e1s1"})).andDo(MockMvcResultHandlers.print());
        }
        catch (NestedServletException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ExternalAuthenticationException));
            this.log.error("{}", (Object)e.getRootCause().getMessage());
        }
    }

    @Test
    public void testSuccessfulCallback() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("code", new String[]{"db87f45083db5aea16eb45b7ace685c8"}).param("state", new String[]{this.state})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().is3xxRedirection());
        DuoOIDCAuthenticationContext duoContext = this.extractDuoContext();
        Assert.assertEquals((String)"db87f45083db5aea16eb45b7ace685c8", (String)duoContext.getAuthorizationCode());
        Assert.assertEquals((String)"8821febf7b3237fc3974f76a75f37e8c", (String)duoContext.getResponseState());
    }

    @Test
    public void testCallbackNoDuoAuthenticationContext() throws Exception {
        this.removeDuoContext();
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("code", new String[]{"db87f45083db5aea16eb45b7ace685c8"}).param("state", new String[]{this.state})).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andReturn();
        Object extAuthErrorObject = result.getRequest().getAttribute("authnError");
        Assert.assertNotNull((Object)extAuthErrorObject);
        Assert.assertTrue((boolean)(extAuthErrorObject instanceof String));
        Assert.assertEquals((String)"InvalidProfileContext", (String)((String)extAuthErrorObject));
    }

    @Test
    public void testCallbackNoCode() throws Exception {
        try {
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("state", new String[]{this.state})).andDo(MockMvcResultHandlers.print());
        }
        catch (NestedServletException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ExternalAuthenticationException));
            this.log.error("{}", (Object)e.getMessage());
        }
    }

    @Test
    public void testCallbackNoState() throws Exception {
        try {
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/Authn/Duo/2FA/duo-callback", (Object[])new Object[0]).param("code", new String[]{"db87f45083db5aea16eb45b7ace685c8"})).andDo(MockMvcResultHandlers.print());
        }
        catch (NestedServletException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ExternalAuthenticationException));
            this.log.error("{}", (Object)e.getMessage());
        }
    }

    private void exportServletContextAttributes() throws DuoClientException {
        FlowExecutorImpl mockFlowExecutor = (FlowExecutorImpl)Mockito.mock(FlowExecutorImpl.class);
        FlowExecutionRepository mockFlowExecutionRepo = (FlowExecutionRepository)Mockito.mock(FlowExecutionRepository.class);
        FlowExecution mockFlowExecution = (FlowExecution)Mockito.mock(FlowExecution.class);
        LocalAttributeMap map = new LocalAttributeMap();
        map.put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext());
        Mockito.when((Object)mockFlowExecutor.getExecutionRepository()).thenReturn((Object)mockFlowExecutionRepo);
        CompositeFlowExecutionKey key = new CompositeFlowExecutionKey((Serializable)((Object)"1"), (Serializable)((Object)"1"));
        Mockito.when((Object)mockFlowExecutionRepo.parseFlowExecutionKey("e1s1")).thenReturn((Object)key);
        Mockito.when((Object)mockFlowExecutionRepo.getFlowExecution((FlowExecutionKey)key)).thenReturn((Object)mockFlowExecution);
        Mockito.when((Object)mockFlowExecution.getConversationScope()).thenReturn((Object)map);
        this.servletContext.setAttribute("net.shibboleth.idp.flowExecutor", (Object)mockFlowExecutor);
    }

    @Nonnull
    private ProfileRequestContext buildProfileRequestContext() throws DuoClientException {
        ProfileRequestContext prc = new ProfileRequestContext();
        AuthenticationContext ac = new AuthenticationContext();
        ExternalAuthenticationContext ec = new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl());
        DuoOIDCAuthenticationContext dc = new DuoOIDCAuthenticationContext();
        ec.setFlowExecutionUrl("http://localhost/idp/profile/SSO&_eventId_proceed=1");
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setAPIHost("duo.host.com");
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setRegisteredRedirectURI("http://localhost/");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        dc.setUsername("jdoe");
        dc.setIntegration((DuoOIDCIntegration)integ);
        dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK((DuoOIDCIntegration)integ));
        dc.setRequestState("8821febf7b3237fc3974f76a75f37e8c");
        AuthenticationFlowDescriptor afd = new AuthenticationFlowDescriptor();
        afd.setId("authn/DuoOIDC");
        ac.setAttemptedFlow(afd);
        ac.addSubcontext((BaseContext)new RelyingPartyUIContext());
        ac.setForceAuthn(false);
        SubjectCanonicalizationContext scc = new SubjectCanonicalizationContext();
        scc.setPrincipalName("jdoe");
        SessionContext sc = new SessionContext();
        IdPSession idpSession = (IdPSession)Mockito.mock(IdPSession.class);
        Mockito.when((Object)idpSession.getPrincipalName()).thenReturn((Object)"jdoe");
        sc.setIdPSession(idpSession);
        ac.addSubcontext((BaseContext)dc);
        ac.addSubcontext((BaseContext)ec);
        prc.addSubcontext((BaseContext)scc);
        prc.addSubcontext((BaseContext)ac);
        prc.addSubcontext((BaseContext)sc);
        return prc;
    }

    private void removeDuoContext() {
        Object flowExecutorObject = this.servletContext.getAttribute("net.shibboleth.idp.flowExecutor");
        Assert.assertTrue((boolean)(flowExecutorObject instanceof FlowExecutorImpl));
        Object prcObject = ((FlowExecutorImpl)flowExecutorObject).getExecutionRepository().getFlowExecution((FlowExecutionKey)new CompositeFlowExecutionKey((Serializable)((Object)"1"), (Serializable)((Object)"1"))).getConversationScope().get("opensamlProfileRequestContext");
        ((AuthenticationContext)((ProfileRequestContext)prcObject).getSubcontext(AuthenticationContext.class)).removeSubcontext(DuoOIDCAuthenticationContext.class);
    }

    @Nonnull
    private DuoOIDCAuthenticationContext extractDuoContext() {
        Object flowExecutorObject = this.servletContext.getAttribute("net.shibboleth.idp.flowExecutor");
        Assert.assertTrue((boolean)(flowExecutorObject instanceof FlowExecutorImpl));
        Object prcObject = ((FlowExecutorImpl)flowExecutorObject).getExecutionRepository().getFlowExecution((FlowExecutionKey)new CompositeFlowExecutionKey((Serializable)((Object)"1"), (Serializable)((Object)"1"))).getConversationScope().get("opensamlProfileRequestContext");
        Assert.assertTrue((boolean)(prcObject instanceof ProfileRequestContext));
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)((AuthenticationContext)((ProfileRequestContext)prcObject).getSubcontext(AuthenticationContext.class)).getSubcontext(DuoOIDCAuthenticationContext.class);
        Assert.assertNotNull((Object)duoContext);
        return duoContext;
    }
}

