/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoNonceClaimLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DuoNonceClaimLookupStrategyTest
extends AbstractDuoActionTest {
    @Nonnull
    private DuoNonceClaimLookupStrategy strategy;

    @BeforeMethod
    public void beforeMethod() throws ComponentInitializationException {
        super.setup();
        this.strategy = new DuoNonceClaimLookupStrategy();
    }

    @Test
    public void applySuccess() {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setNonce("testnonce");
        String nonce = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)nonce, (String)"testnonce");
    }

    @Test
    public void applyNoDuoContext() {
        String nonce = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)nonce, null);
    }

    @Test
    public void applyNoDuoIntegration() {
        this.addDuoContext();
        String nonce = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)nonce, null);
    }
}

