/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.authn.duo.DynamicDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.impl.DefaultRedirectURICreationStrategy;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRedirectURICreationStrategyTest {
    private static final String CALLBACK_PATH = "/Authn/Duo/2FA//duo-callback";
    private DefaultRedirectURICreationStrategy strategy;
    @Mock
    private DynamicDuoOIDCIntegration integration;
    private MockHttpServletRequest request;

    @BeforeMethod
    public void setUp() throws Exception {
        this.request = new MockHttpServletRequest();
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public final void testComputedRedirectAllowed() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"allowed.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("https://allowed.com"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, (String)"https://allowed.com/Authn/Duo/2FA//duo-callback");
    }

    @Test
    public final void testComputedRedirectDisallowed() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"not-allowed.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("https://allowed.com"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, null);
    }

    @Test
    public final void testComputedRedirectAllowedHTTPSCustomPort() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"allowed.com");
        this.request.setServerPort(8443);
        this.request.setScheme("https");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("https://allowed.com:8443"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, (String)"https://allowed.com:8443/Authn/Duo/2FA//duo-callback");
    }

    @Test
    public final void testComputedRedirectAllowedHTTPCustomPort() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"allowed.com");
        this.request.setServerPort(8080);
        this.request.setScheme("http");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("http://allowed.com:8080"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, (String)"http://allowed.com:8080/Authn/Duo/2FA//duo-callback");
    }

    @Test
    public final void testComputedRedirectAllowedNullPort() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"allowed.com");
        this.request.setServerPort(-1);
        this.request.setScheme("http");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("http://allowed.com"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, (String)"http://allowed.com/Authn/Duo/2FA//duo-callback");
    }

    @Test
    public final void testComputedRedirectDisallowedOnPort() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"allowed.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("https://allowed.com:8443"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, null);
    }

    @Test
    public final void testPreregisteredURL() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"notused.com");
        this.request.setServerPort(443);
        this.request.setScheme("https");
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn((Object)"https://registered.com/Authn/Duo/2FA//duo-callback");
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)true);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, (String)"https://registered.com/Authn/Duo/2FA//duo-callback");
    }

    @Test
    public final void testComputedRedirectBadHostname() throws Exception {
        this.strategy = new DefaultRedirectURICreationStrategy(CALLBACK_PATH);
        this.request.addHeader("Host", (Object)"<script>inject</script>");
        this.request.setServerPort(80);
        this.request.setScheme("http");
        Mockito.when((Object)this.integration.getAllowedOrigins()).thenReturn(Set.of("http://allowed.com"));
        Mockito.when((Object)this.integration.getRegisteredRedirectURI()).thenReturn(null);
        Mockito.when((Object)this.integration.isRedirectURIPreregistered()).thenReturn((Object)false);
        String redirect = this.strategy.apply((HttpServletRequest)this.request, this.integration);
        Assert.assertEquals((String)redirect, null);
    }
}

