/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.config.BooleanToPredicateConverter;
import net.shibboleth.ext.spring.config.FunctionToFunctionConverter;
import net.shibboleth.ext.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.ext.spring.config.PredicateToPredicateConverter;
import net.shibboleth.ext.spring.config.StringBooleanToPredicateConverter;
import net.shibboleth.ext.spring.config.StringToDurationConverter;
import net.shibboleth.ext.spring.config.StringToIPRangeConverter;
import net.shibboleth.ext.spring.config.StringToResourceConverter;
import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.spring.CustomAbstractXmlFlowExecutionTests;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestSupplier;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseSupplier;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.mock.env.MockPropertySource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.config.FlowDefinitionResourceFactory;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowBuilderContext;

public abstract class AbstractAuthnXmlFlowExecutionTests
extends CustomAbstractXmlFlowExecutionTests {
    protected MockHttpServletRequest mockRequest;
    protected MockHttpServletResponse mockResponse;
    protected MockExternalContext externalContext;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAuthnXmlFlowExecutionTests.class);
    @Nonnull
    private String flowPath;
    @Nonnull
    private Map<String, String> flowModelResources = Collections.emptyMap();
    @Nonnull
    private List<Flow> subflows = Collections.emptyList();
    @Nonnull
    private Map<String, String> mockProperties = Collections.emptyMap();
    @Nullable
    private DuoOIDCClientFactory clientFactory;
    private boolean removeDefaultContextCleanupHook = false;
    @Nonnull
    private final String entityId;

    public AbstractAuthnXmlFlowExecutionTests(@Nonnull String idpEntityID) {
        this.entityId = Objects.requireNonNull(idpEntityID);
    }

    public void setFlowModelResources(@Nonnull Map<String, String> testFlowModelResources) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(testFlowModelResources);
        this.flowModelResources = testFlowModelResources;
    }

    public void setClientFactory(@Nonnull DuoOIDCClientFactory factory) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)factory);
        this.clientFactory = factory;
    }

    public void setFlowPath(@Nonnull @NotEmpty String testFlowPath) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)testFlowPath);
        this.flowPath = testFlowPath;
    }

    public void setMockProperties(@Nonnull Map<String, String> properties) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(properties);
        this.mockProperties = properties;
    }

    public void setSubflows(@Nonnull @NonnullElements List<Flow> mockSubflows) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(mockSubflows);
        this.subflows = mockSubflows;
    }

    public void addHttpBasicAuthHeader(@Nonnull String username, @Nonnull String password) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)username);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)password);
        this.mockRequest.addHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes())));
    }

    public void setUp() throws NoSuchFieldException, SecurityException, Exception {
        this.mockRequest = new MockHttpServletRequest();
        this.mockResponse = new MockHttpServletResponse();
        this.externalContext = new MockExternalContext();
        this.externalContext.setNativeRequest((Object)this.mockRequest);
        this.externalContext.setNativeResponse((Object)this.mockResponse);
        this.removeDefaultContextCleanupHook = false;
    }

    protected FlowDefinitionResource getResource(FlowDefinitionResourceFactory resourceFactory) {
        return resourceFactory.createClassPathResource(this.flowPath, ((Object)((Object)this)).getClass());
    }

    @Override
    protected FlowDefinitionResource[] getModelResources(FlowDefinitionResourceFactory resourceFactory) {
        if (!this.flowModelResources.isEmpty()) {
            FlowDefinitionResource[] resources = new FlowDefinitionResource[this.flowModelResources.size()];
            int rIndex = 0;
            for (Map.Entry<String, String> entry : this.flowModelResources.entrySet()) {
                resources[rIndex++] = resourceFactory.createResource(entry.getKey(), null, entry.getValue());
            }
            return resources;
        }
        return null;
    }

    protected void configureFlowBuilderContext(MockFlowBuilderContext builderContext) {
        this.registerMockBeanDefinitions(builderContext);
        this.registerMockPropertySource(builderContext);
        this.registerMockSubflows(builderContext);
    }

    private void registerMockSubflows(@Nonnull MockFlowBuilderContext builderContext) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        this.subflows.forEach(flow -> builderContext.registerSubflow(flow));
    }

    protected void loadBeanDefinitionsFromXmlFile(@Nonnull MockFlowBuilderContext builderContext, @Nonnull Resource xmlFile, @Nullable Map<String, String> additionalProperties) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)xmlFile.exists());
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(builderContext.getApplicationContext() instanceof ConfigurableApplicationContext));
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)builderContext.getApplicationContext()).getBeanFactory();
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)factory);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(factory instanceof DefaultListableBeanFactory));
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)((DefaultListableBeanFactory)factory));
        ((DefaultListableBeanFactory)factory).addBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor());
        ((DefaultListableBeanFactory)factory).setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        ConversionServiceFactoryBean conversationService = new ConversionServiceFactoryBean();
        conversationService.setConverters(this.createConverters());
        conversationService.afterPropertiesSet();
        ((DefaultListableBeanFactory)factory).setConversionService(conversationService.getObject());
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.addProtocolResolver((ProtocolResolver)new ConditionalResourceResolver());
        ((GenericApplicationContext)builderContext.getApplicationContext()).setResourceLoader((ResourceLoader)loader);
        int beanNumbers = beanDefinitionReader.loadBeanDefinitions(new EncodedResource(xmlFile, "UTF-8"));
        Properties mock = new Properties();
        mock.setProperty("idp.home", "classpath:");
        mock.setProperty("idp.entityID", this.entityId);
        mock.setProperty("idp.webflows", "classpath*:/flows");
        if (additionalProperties != null) {
            additionalProperties.forEach((k, v) -> {
                this.log.debug("Adding property ['{}':'{}']", k, v);
                mock.setProperty((String)k, (String)v);
            });
        }
        PropertySourcesPlaceholderConfigurer ppc = new PropertySourcesPlaceholderConfigurer();
        ppc.setProperties(mock);
        ppc.setPlaceholderPrefix("%{");
        ppc.setPlaceholderSuffix("}");
        ppc.postProcessBeanFactory((ConfigurableListableBeanFactory)((DefaultListableBeanFactory)factory));
        this.log.info("Loaded {} beans from {}", (Object)beanNumbers, (Object)xmlFile);
    }

    private Set<Converter<?, ?>> createConverters() {
        return Set.of(new StringToDurationConverter(), new StringToResourceConverter(), new StringToIPRangeConverter(), new BooleanToPredicateConverter(), new StringBooleanToPredicateConverter(), new StringToResourceConverter(), new FunctionToFunctionConverter(), new PredicateToPredicateConverter());
    }

    protected void registerMockBeanDefinitions(@Nonnull MockFlowBuilderContext builderContext) {
        builderContext.registerBean("shibboleth.DefaultIdentifierGenerationStrategy", (Object)new SecureRandomIdentifierGenerationStrategy());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.mockRequest, (HttpServletResponse)this.mockResponse);
        builderContext.registerBean("shibboleth.PostLoginSubjectCanonicalizationFlows", Collections.emptyList());
        builderContext.registerBean("shibboleth.JSONObjectMapper", (Object)new ObjectMapper());
        ConversionServiceFactoryBean conversationService = new ConversionServiceFactoryBean();
        conversationService.setConverters(this.createConverters());
        conversationService.afterPropertiesSet();
        builderContext.registerBean("conversionService", (Object)conversationService.getObject());
        this.addBeanDefinition(builderContext, "shibboleth.RelyingPartyIdLookup.Simple", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RelyingPartyIdLookupFunction.class).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.MessageContextLookup.Inbound", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(InboundMessageContextLookup.class).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.ChildLookup.SessionContext", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ChildContextLookup.class).addConstructorArgValue(SessionContext.class).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.ChildLookupOrCreate.SAMLMessageInfoContext", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ChildContextLookup.class).addConstructorArgValue(SAMLMessageInfoContext.class).addConstructorArgValue((Object)true).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.HttpServletRequestSupplier", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ThreadLocalHttpServletRequestSupplier.class).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.HttpServletResponseSupplier", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ThreadLocalHttpServletResponseSupplier.class).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.Functions.Constant", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FunctionSupport.class).setFactoryMethod("constant").setAbstract(true).getBeanDefinition());
        if (this.clientFactory != null) {
            builderContext.registerBean("shibboleth.authn.DuoOIDC.test.clientFactory", (Object)this.clientFactory);
        }
        if (this.isRemoveDefaultContextCleanupHook()) {
            builderContext.registerBean("shibboleth.authn.DuoOIDC.CleanUpHook", (Object)new Consumer<ProfileRequestContext>(){

                @Override
                public void accept(ProfileRequestContext t) {
                }
            });
        }
        this.addBeanDefinition(builderContext, "shibboleth.Functions.Compose", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FunctionSupport.class).setFactoryMethod("compose").setAbstract(true).getBeanDefinition());
        this.addBeanDefinition(builderContext, "shibboleth.ChildLookup.AuthenticationContext", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ChildContextLookup.class).addConstructorArgValue(AuthenticationContext.class).getBeanDefinition());
    }

    private void addBeanDefinition(@Nonnull MockFlowBuilderContext builderContext, @Nonnull String beanName, @Nonnull BeanDefinition bean) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)beanName);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)bean);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(builderContext.getApplicationContext() instanceof ConfigurableApplicationContext));
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)builderContext.getApplicationContext()).getBeanFactory();
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)factory);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(factory instanceof DefaultListableBeanFactory));
        ((DefaultListableBeanFactory)factory).registerBeanDefinition(beanName, bean);
    }

    private void registerMockPropertySource(@Nonnull MockFlowBuilderContext builderContext) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext.getApplicationContext());
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext.getApplicationContext().getEnvironment());
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(builderContext.getApplicationContext().getEnvironment() instanceof StandardEnvironment));
        MockPropertySource mock = new MockPropertySource();
        mock.setProperty("idp.home", (Object)"classpath:");
        mock.setProperty("idp.webflows", (Object)"classpath*:/flows");
        this.mockProperties.forEach((key, value) -> mock.setProperty(key, value));
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).getPropertySources().addFirst((PropertySource)mock);
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).setPlaceholderPrefix("%{");
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).setPlaceholderSuffix("}");
    }

    @Nonnull
    protected ProfileRequestContext buildProfileRequestContext(@Nonnull boolean forceAuthn, @Nonnull boolean addC14Context) {
        ProfileRequestContext prc = new ProfileRequestContext();
        AuthenticationContext ac = new AuthenticationContext();
        AuthenticationFlowDescriptor afd = new AuthenticationFlowDescriptor();
        afd.setId("authn/DuoOIDC");
        ac.setAttemptedFlow(afd);
        ac.addSubcontext((BaseContext)new RelyingPartyUIContext());
        ac.setForceAuthn(forceAuthn);
        prc.addSubcontext((BaseContext)ac);
        if (addC14Context) {
            SubjectCanonicalizationContext scc = new SubjectCanonicalizationContext();
            scc.setPrincipalName("jdoe");
            prc.addSubcontext((BaseContext)scc);
        }
        SessionContext sc = new SessionContext();
        IdPSession session = (IdPSession)Mockito.mock(IdPSession.class);
        Mockito.when((Object)session.getPrincipalName()).thenReturn((Object)"jdoe");
        sc.setIdPSession(session);
        prc.addSubcontext((BaseContext)sc);
        prc.setBrowserProfile(true);
        return prc;
    }

    protected boolean isRemoveDefaultContextCleanupHook() {
        return this.removeDefaultContextCleanupHook;
    }

    protected void setRemoveDefaultContextCleanupHook(boolean removeDefaultContextCleanupHook) {
        this.removeDefaultContextCleanupHook = removeDefaultContextCleanupHook;
    }
}

