/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo.audit.impl;

import java.util.function.Function;

import javax.annotation.Nonnull;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;

/** A simple audit extractor that allows a fixed string to be logged.*/
public class FixedStringAuditExtractor implements Function<ProfileRequestContext, String> {
    
    /** The fixed string to log.*/
    @Nonnull private final String value;
    
    /**
     * Constructor.
     *
     * @param stringToLog the fixed string to log
     */
    public FixedStringAuditExtractor(@Nonnull @NotEmpty @ParameterName(name = "value") final String stringToLog) {
        value = Constraint.isNotEmpty(stringToLog, "The fixed string to log can not be empty");
    }

    @Override
    public String apply(final ProfileRequestContext input) {
        return value;
    }
}
