package net.shibboleth.idp.plugin.authn.duo.audit.impl;

import java.util.function.Function;

import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;

/** An audit extractor to pull out the attempted authentication flow ID from the current authentication context.*/
public class AttemptedAuthenticationFlowIdAuditExtractor  implements Function<ProfileRequestContext, String> {

    @Override
    public String apply(@Nullable final ProfileRequestContext profileRequestContext) {
        
        if (profileRequestContext == null) {
            return null;
        }
        
        final AuthenticationContext authContext = 
                profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authContext != null) {
            final AuthenticationFlowDescriptor afd = authContext.getAttemptedFlow();
            if (afd != null) {
                return afd.getId();
            }
        }
        return null;
        
    }

}
