/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.duo.DuoPrincipal;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDuoTokenAuthenticationResult
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateDuoTokenAuthenticationResult.class);
    @Nullable
    private DuoOIDCAuthenticationContext duoContext;
    @Nullable
    private ProfileRequestContext prc;
    @Nullable
    private JWTClaimsSet claimsSet;
    @Nullable
    @NotEmpty
    private String username;
    @Nullable
    private Function<ProfileRequestContext, Collection<Principal>> contextToPrincipalMappingStrategy;

    @Nullable
    public Function<ProfileRequestContext, Collection<Principal>> getContextToPrincipalMappingStrategy() {
        return this.contextToPrincipalMappingStrategy;
    }

    public void setContextToPrincipalMappingStrategy(@Nullable Function<ProfileRequestContext, Collection<Principal>> hook) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.contextToPrincipalMappingStrategy = hook;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.prc = profileRequestContext;
        this.duoContext = (DuoOIDCAuthenticationContext)authenticationContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (this.duoContext == null) {
            this.log.error("{} No DuoAuthenticationContext available", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "No DuoAuthenticationContext context available", "InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        this.username = this.duoContext.getUsername();
        JWT token = this.duoContext.getAuthToken();
        if (token == null) {
            this.log.error("{} Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        try {
            this.claimsSet = token.getJWTClaimsSet();
            if (this.claimsSet == null) {
                throw new DuoException("Duo JWT ClaimsSet is null");
            }
        }
        catch (ParseException | DuoException e) {
            this.log.error("{} Claimset of Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map authStatusObject = null;
        try {
            authStatusObject = this.claimsSet.getJSONObjectClaim("auth_result");
            if (authStatusObject == null) {
                throw new DuoException("Authentication result object is null");
            }
        }
        catch (ParseException | DuoException e) {
            this.log.error("{} Duo 2FA access failed for '{}', auth_result missing", (Object)this.getLogPrefix(), (Object)this.username);
            this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        Object statusObj = authStatusObject.get("status");
        Object statusMsgObj = authStatusObject.get("status_msg");
        if (statusObj instanceof String && statusMsgObj instanceof String) {
            String authResultStatus = (String)statusObj;
            String authResultStatusMsg = (String)statusMsgObj;
            if ("allow".equalsIgnoreCase(authResultStatus)) {
                this.log.info("{} Duo 2FA authentication succeeded for '{}', using second-factor '{}'", new Object[]{this.getLogPrefix(), this.duoContext.getUsername(), this.extractFactor()});
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                this.recordSuccess(profileRequestContext);
                return;
            }
            if ("deny".equalsIgnoreCase(authResultStatus)) {
                this.log.error("{} Duo 2FA failed for '{}', 2FA status '{}'", new Object[]{this.getLogPrefix(), this.username, authResultStatusMsg});
                this.handleError(profileRequestContext, authenticationContext, authResultStatus, "InvalidCredentials");
                this.recordFailure(profileRequestContext);
                return;
            }
            this.log.error("{} Duo 2FA access failed for '{}', unknown response", (Object)this.getLogPrefix(), (Object)this.username);
            this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        this.log.error("{} Duo 2FA access failed for '{}', auth_results missing", (Object)this.getLogPrefix(), (Object)this.username);
        this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
        this.recordFailure(profileRequestContext);
    }

    @Nonnull
    private String extractFactor() {
        String factor = "unspecified";
        try {
            Object factorClaimObj;
            Map authnContextClaimObj = this.claimsSet.getJSONObjectClaim("auth_context");
            if (authnContextClaimObj != null && (factorClaimObj = authnContextClaimObj.get("factor")) instanceof String) {
                factor = (String)factorClaimObj;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return factor;
    }

    protected Subject populateSubject(@Nonnull Subject subject) {
        Collection<Principal> mapped;
        subject.getPrincipals().add((Principal)new DuoPrincipal(this.username));
        subject.getPrincipals().addAll(this.duoContext.getIntegration().getSupportedPrincipals(Principal.class));
        if (this.getContextToPrincipalMappingStrategy() != null && (mapped = this.getContextToPrincipalMappingStrategy().apply(this.prc)) != null) {
            subject.getPrincipals().addAll(mapped);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Added mapped Principals: {}", (Object)this.getLogPrefix(), mapped.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
        }
        return subject;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        super.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ((SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class, true)).setPrincipalName(this.username);
    }

    public static class DuoOIDCCleanupHook
    implements Consumer<ProfileRequestContext> {
        @Override
        public void accept(@Nullable ProfileRequestContext input) {
            DuoOIDCAuthenticationContext duoCtx;
            AuthenticationContext authnCtx;
            if (input != null && (authnCtx = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && (duoCtx = (DuoOIDCAuthenticationContext)authnCtx.getSubcontext(DuoOIDCAuthenticationContext.class)) != null) {
                authnCtx.removeSubcontext((BaseContext)duoCtx);
            }
        }
    }
}

