/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public final class DuoIssuerClaimLookupStrategy
implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {
    @Nonnull
    @NotEmpty
    public static final String HTTPS = "https://";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ISSUER_PATH = "/oauth/v1/token";
    @Nonnull
    @NotEmpty
    @GuardedBy(value="this")
    private final String issuerPath;

    public DuoIssuerClaimLookupStrategy(@Nullable @ParameterName(name="issuerPath") String path) {
        this.issuerPath = path == null ? DEFAULT_ISSUER_PATH : Constraint.isNotEmpty((String)path, (String)"Issuer URL path cannot be null or empty");
    }

    @Override
    @Nullable
    public String apply(@Nonnull ProfileRequestContext context, @Nonnull JWTClaimsSet cliams) {
        AuthenticationContext authnContext = (AuthenticationContext)context.getSubcontext(AuthenticationContext.class);
        if (authnContext == null) {
            return null;
        }
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)authnContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoContext == null) {
            return null;
        }
        DuoOIDCIntegration duoIntegration = duoContext.getIntegration();
        if (duoIntegration == null) {
            return null;
        }
        return HTTPS + duoIntegration.getAPIHost() + this.issuerPath;
    }
}

