/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateDuoAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateDuoAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoAuthContextCreationStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCIntegration> duoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @NonnullAfterInit
    private DuoOIDCClientRegistry clientRegistry;

    public void setClientRegistry(@Nonnull DuoOIDCClientRegistry duoRegistry) {
        this.clientRegistry = (DuoOIDCClientRegistry)Constraint.isNotNull((Object)duoRegistry, (String)"DuoClient registry can not be null");
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setDuoContextCreationStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.duoAuthContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoAuthenticationContext creation strategy cannot be null");
    }

    public void setDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCIntegration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.duoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoIntegration lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientRegistry == null) {
            throw new ComponentInitializationException("Duo Client Registry cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        DuoOIDCAuthenticationContext context = this.duoAuthContextCreationStrategy.apply(profileRequestContext);
        if (context == null) {
            this.log.error("{} Error creating DuoAuthenticationContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        DuoOIDCIntegration duoIntegration = this.duoIntegrationLookupStrategy.apply(profileRequestContext);
        if (duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        context.setIntegration(duoIntegration);
        String username = this.usernameLookupStrategy.apply(profileRequestContext);
        if (username == null) {
            this.log.warn("{} No principal name available to initiate a Duo 2FA request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        context.setUsername(username);
        try {
            DuoOIDCClient client = this.clientRegistry.getClientOrCreate(duoIntegration);
            context.setClient(client);
        }
        catch (DuoRegistryException e) {
            this.log.warn("{} No DuoClient established (located or created) for this integration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            return;
        }
        this.log.debug("Created Duo authentication context for '{}'", (Object)username);
    }
}

