/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoAuthenticationAction;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckDuoOIDCAuthAPI
extends AbstractDuoAuthenticationAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(HealthCheckDuoOIDCAuthAPI.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        try {
            DuoOIDCClient client = duoContext.getClient();
            if (client == null) {
                throw new DuoClientException("Duo client is null, has the context been created correctly?");
            }
            DuoHealthCheck healthCheckResponse = client.healthCheck();
            this.log.trace("{} Duo health check response '{}'", (Object)this.getLogPrefix(), (Object)healthCheckResponse);
            if (healthCheckResponse == null) {
                throw new DuoClientException("Duo 2FA is unavailable, null response from the health check endpoint");
            }
            if ("OK".equalsIgnoreCase(healthCheckResponse.getStatus())) {
                this.log.trace("{} Duo 2FA endpoints are healthy!", (Object)this.getLogPrefix());
                return;
            }
            if ("FAIL".equalsIgnoreCase(healthCheckResponse.getStatus())) {
                this.log.error("{} Duo 2FA health check failed, current status '{}', message '{}', message detail '{}'", new Object[]{this.getLogPrefix(), healthCheckResponse.getStatus(), healthCheckResponse.getMessage(), healthCheckResponse.getMessageDetail()});
                throw new DuoClientException("Duo 2FA health check responded with a failure status of: " + healthCheckResponse.getMessage());
            }
            this.log.error("{} Duo health check response contained an unknown status of '{}',  message '{}', message detail '{}'", new Object[]{this.getLogPrefix(), healthCheckResponse.getStatus(), healthCheckResponse.getMessage(), healthCheckResponse.getMessageDetail()});
            throw new DuoClientException("Duo 2FA health check returned an unknown status response: " + healthCheckResponse.getMessage());
        }
        catch (DuoClientException e) {
            this.log.error("{} Duo API health check failed", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            return;
        }
    }
}

