/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoClientInitializationException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class DefaultDuoOIDCClientRegistry
extends AbstractIdentifiableInitializableComponent
implements DuoOIDCClientRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDuoOIDCClientRegistry.class);
    @NonnullAfterInit
    private DuoOIDCClientFactory clientFactory;
    @Nonnull
    @NonnullElements
    private final ConcurrentMap<DuoOIDCIntegration, DuoOIDCClient> clientRegistry = new ConcurrentHashMap<DuoOIDCIntegration, DuoOIDCClient>(1);
    @Nonnull
    private Function<DuoOIDCIntegration, DuoOIDCClient> clientRegistryMappingFunction = new CreateNewClientMappingFunction();

    public void setClientFactory(@Nonnull DuoOIDCClientFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientFactory = (DuoOIDCClientFactory)Constraint.isNotNull((Object)factory, (String)"Duo client factory can not be null");
    }

    @Nonnull
    public DuoOIDCClient getClientOrCreate(@Nonnull DuoOIDCIntegration integration) throws DuoRegistryException {
        Constraint.isNotNull((Object)integration, (String)"Duo integration can not be null");
        try {
            DuoOIDCClient client = this.clientRegistry.computeIfAbsent(integration, this.clientRegistryMappingFunction);
            this.log.debug("Duo registry returning the DuoClient instance '{}' of type '{}'", (Object)client.getClientId(), (Object)client.getClass().getCanonicalName());
            return client;
        }
        catch (DuoClientInitializationException e) {
            throw new DuoRegistryException("DuoClient could not be found or created in the registry", (Throwable)e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientFactory == null) {
            throw new ComponentInitializationException("A Duo Client Factory must be configured and cannot be null");
        }
    }

    private class CreateNewClientMappingFunction
    implements Function<DuoOIDCIntegration, DuoOIDCClient> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(CreateNewClientMappingFunction.class);

        private CreateNewClientMappingFunction() {
        }

        @Override
        @Nonnull
        public DuoOIDCClient apply(@Nonnull DuoOIDCIntegration integration) {
            try {
                this.log.debug("Creating a new Duo client for integration '{}', using factory type '{}'", (Object)integration, (Object)DefaultDuoOIDCClientRegistry.this.clientFactory.getClass().getTypeName());
                return DefaultDuoOIDCClientRegistry.this.clientFactory.createInstance(integration);
            }
            catch (DuoClientException e) {
                throw new DuoClientInitializationException("Could not initialise the DuoClient for the integration with clientId " + integration.getClientId(), (Throwable)e);
            }
        }
    }
}

