/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.shared.annotation.constraint.NotEmpty;


/**
 * Interface to a particular Duo OIDC integration point. In part replaces
 * OIDC metadata, as that is not supported by Duo.
 */
public interface DuoOIDCIntegration extends PrincipalSupportingComponent {
    
    /**
     * Get the name of the API host to contact.
     * 
     * @return name of API host
     */
    @Nonnull @NotEmpty String getAPIHost();

    /**
     * Get the clientId key.
     * 
     * @return the integration key
     */
    @Nonnull @NotEmpty String getClientId();

    /**
     * Get the secret key.
     * 
     * @return the secret key
     */
    @Nonnull @NotEmpty String getSecretKey();    
    
    /**
     * Get the runtime redirectURI to direct the client to after authorisation. 
     * 
     * @return the redirectURI
     */
    @Nullable String getRedirectURI();    
    
    /**
     * Get the path of the health check endpoint.
     * 
     * @return the path of the health check endpoint
     */
    @Nonnull @NotEmpty String getHealthCheckEndpoint();
    
    /**
     * Get the path of the authorization endpoint.
     * 
     * @return the path of the authorization endpoint
     */
    @Nonnull @NotEmpty String getAuthorizeEndpoint();
    
    /**
     * Get the path of the token endpoint.
     * 
     * @return the path of the token endpoint;
     */
    @Nonnull @NotEmpty String getTokenEndpoint();

    


}
