/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

import javax.annotation.Nonnull;

/**
 * A registry of {@link DuoOIDCClient}s for {@link DuoOIDCIntegration}s.
 * 
 * <p>The registry *must* be thread-safe.</p>
 */
public interface DuoOIDCClientRegistry {
    
    /**
     * <p>Retrieve an existing, or create a new, Duo client for the given Duo integration.
     * The client should be fully initialised and safely published on return.</p> 
     * 
     * <p>implSpec: Only one client should exist per integration i.e. given the same integration, 
     * the same client instance should be returned.</p>
     * 
     * <p>implNote: Clients could either be pre-registered, or lazy-initialised when first needed.</p>
     *  
     * @param integration the Duo integration to find a client for, never {@code null}.
     * 
     * @return a {@link DuoOIDCClient} appropriate for this integration, never {@code null}.
     * 
     * @throws DuoRegistryException if there is an issue locating or creating a Duo client.
     */
    @Nonnull DuoOIDCClient getClientOrCreate(@Nonnull final DuoOIDCIntegration integration) 
               throws DuoRegistryException;

}
