/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

/**
 * Exposes capabilities of a {@link DuoOIDCClient}.
 */
public interface DuoOIDCClientCapabilities {
    
    /**
     * <p>Does this client support the OIDC nonce parameter.</p>
     * 
     * <p>If the client does support a nonce, it <b>must</b> be included by the client in the authorisation request URL,
     * where it must then be returned by the provider in the id_token as part of the 2FA result.</p>
     * 
     * @return true iff the client supports the nonce parameter, false otherwise.
     */
    boolean isSupportsNonce();   
   

}
