/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

import javax.annotation.concurrent.ThreadSafe;

/** 
 * An exception to signal an error condition during execution of a Duo client.
 */
@ThreadSafe
public class DuoClientException extends DuoException{

    /** Serial UID. */
    private static final long serialVersionUID = -2380145079984333546L;

    /**
     * Constructor.
     *
     */
    public DuoClientException() {
        super();
        
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     * @param cause exception to be wrapped by this one
     */
    public DuoClientException(final String message, final Throwable cause) {
        super(message, cause);
        
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     */
    public DuoClientException(final String message) {
        super(message);
        
    }

    /**
     * Constructor.
     * 
     * @param cause exception to be wrapped by this one
     */
    public DuoClientException(final Throwable cause) {
        super(cause);
        
    }




}
