/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.audit;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.audit.AbstractDuoAuditExtractor;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public abstract class AbstractDuoTokenClaimsAuditExtractor<T>
extends AbstractDuoAuditExtractor<T> {
    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext profileRequestContext) {
        if (profileRequestContext == null) {
            return null;
        }
        AuthenticationContext authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authnContext == null) {
            return null;
        }
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)authnContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoContext == null || duoContext.getAuthToken() == null) {
            return null;
        }
        JWTClaimsSet claimsSet = null;
        try {
            claimsSet = duoContext.getAuthToken().getJWTClaimsSet();
            if (claimsSet == null) {
                return null;
            }
        }
        catch (ParseException e) {
            return null;
        }
        return this.doLookup(claimsSet, duoContext);
    }

    @Override
    @Nullable
    protected T doLookup(@Nonnull DuoOIDCAuthenticationContext duoContext) {
        JWTClaimsSet claimsSet = null;
        try {
            claimsSet = duoContext.getAuthToken().getJWTClaimsSet();
            if (claimsSet == null) {
                return null;
            }
        }
        catch (ParseException e) {
            return null;
        }
        return this.doLookup(claimsSet, duoContext);
    }

    @Nullable
    protected abstract T doLookup(@Nonnull JWTClaimsSet var1, @Nonnull DuoOIDCAuthenticationContext var2);
}

