/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDuoAuthenticationAction
extends AbstractAuthenticationAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(AbstractDuoAuthenticationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoContextLookupStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private DuoOIDCAuthenticationContext duoContext;

    protected AbstractDuoAuthenticationAction() {
    }

    public void setDuoContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.duoContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoContextLookuplookup strategy cannot be null");
    }

    protected final boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.duoContext = this.duoContextLookupStrategy.apply(profileRequestContext);
        if (this.duoContext == null) {
            this.log.warn("{} No Duo context returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return this.doPreExecute(profileRequestContext, authenticationContext, this.duoContext);
    }

    protected final void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.doExecute(profileRequestContext, authenticationContext, this.duoContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext context) {
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext context) {
    }
}

