/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.util.Set;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.annotations.Test;

public class DefaultDuoOIDCIntegrationTest {
    @Test
    public void testEverythingSetWithRegisteredRedirectURI() throws ComponentInitializationException {
        DefaultDuoOIDCIntegration integration = new DefaultDuoOIDCIntegration();
        integration.setAPIHost("host.com");
        integration.setAuthorizeEndpoint("/authorize");
        integration.setClientId("CLIENTID");
        integration.setSecretKey("secret");
        integration.setTokenEndpoint("/token");
        integration.setHealthCheckEndpoint("/health");
        integration.setRegisteredRedirectURI("/callback");
        integration.initialize();
    }

    @Test
    public void testEverythingSetWithAllowedOrigins() throws ComponentInitializationException {
        DefaultDuoOIDCIntegration integration = new DefaultDuoOIDCIntegration();
        integration.setAPIHost("host.com");
        integration.setAuthorizeEndpoint("/authorize");
        integration.setClientId("CLIENTID");
        integration.setSecretKey("secret");
        integration.setTokenEndpoint("/token");
        integration.setHealthCheckEndpoint("/health");
        integration.setAllowedOrigins(Set.of("https://host.com"));
        integration.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoRedirectURIOrAllowedHost() throws ComponentInitializationException {
        DefaultDuoOIDCIntegration integration = new DefaultDuoOIDCIntegration();
        integration.setAPIHost("host.com");
        integration.setAuthorizeEndpoint("/authorize");
        integration.setClientId("CLIENTID");
        integration.setSecretKey("secret");
        integration.setTokenEndpoint("/token");
        integration.setHealthCheckEndpoint("/health");
        integration.initialize();
    }
}

