/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo.audit;

import javax.annotation.Nonnull;

import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

/** Constants to use for Duo audit logging fields stored in an {@link AuditContext}. */
public final class AuditFields {
    
    /**
     * Constructor.
     */
    private AuditFields() {
        // no op
    }
    
    /** The id of the currently attempted flow. */
    @Nonnull @NotEmpty public static final String ATTEMPTED_AUTHN_FLOW_ID = "AAF";
    
    /** Duo Transaction ID. */
    @Nonnull @NotEmpty public static final String TXID = "DuoTXID";
    
    /** Duo Device ID (auth_device:key). */
    @Nonnull @NotEmpty public static final String DEVICE_ID = "DuoDID";
    
    /** Duo Device friendly name (auth_device:name). */
    @Nonnull @NotEmpty public static final String DEVICE_NAME = "DuoDN";
    
    /** Duo reason. */
    @Nonnull @NotEmpty public static final String REASON = "DuoR";
    
    /** Duo factor used for 2FA. */
    @Nonnull @NotEmpty public static final String FACTOR = "DuoF";
    
    /** Duo username used for 2FA. */
    @Nonnull @NotEmpty public static final String DUO_USER = "DuoU";
    
    /** The response state value received from the Duo 2FA authz endpoint. */
    @Nonnull @NotEmpty public static final String RESP_STATE = "DuoRespS";
    
    /** The request state value sent to the Duo 2FA authz endpoint. */
    @Nonnull @NotEmpty public static final String REQ_STATE = "DuoReqS";

    /** The redirect URI sent to Duo. */
    @Nonnull @NotEmpty public static final String REDIRECT_URI = "DuoRedirect";
    
    /** The Duo client ID. */
    @Nonnull @NotEmpty public static final String CLIENT_ID = "DuoCID";
}
