/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

import java.util.UUID;

import javax.annotation.Nonnull;

import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

/**
 * Abstract base class for {@link DuoOIDCClient} implementations. Handles the clientId and
 * retrieval of the client's capabilities.
 * 
 * <p>Client's are shared amongst requests - and hence possibly threads - and therefore must be thread-safe</p>
 */
public abstract class AbstractDuoOIDCClient implements DuoOIDCClient{
    
    /** The client instance UUID for identification.*/
    @Nonnull @NotEmpty private final String clientId;
    
    /** Constructor.*/
    protected AbstractDuoOIDCClient() {
        clientId = UUID.randomUUID().toString();
    }
    
    @Override @Nonnull public final String getClientId() {
        return clientId;
    }
    
    @Override @Nonnull public final DuoOIDCClientCapabilities getCapabilities() {
        return this;
    }

}
