package net.shibboleth.idp.plugin.authn.duo.model;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents part of the {@link DuoHealthCheck} response.
 */
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DuoHealthCheckResponse {
    
    /** The response timestamp in seconds since Unix EPOCH.*/
    @Nonnull private final Integer timestamp;
    
    public DuoHealthCheckResponse(@Nonnull @JsonProperty("timestamp") final Integer time) {
        timestamp = time;
    }
    /**
     * Get the response timestamp.
     * 
     * @return the response timestamp.
     */
    @Nonnull public Integer getTimestamp() {
        return timestamp;
    }
    @Override
    public String toString() {
        return "DuoHealthCheckResponse [timestamp=" + timestamp + "]";
    }

}
