/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo;

import javax.annotation.Nonnull;

import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

/**
 * Constants defined in the Duo OIDC Auth API.
 */
public final class DuoOIDCAuthAPI {


    /** Duo AuthAPI auth "allow" result value. */
    @Nonnull @NotEmpty public static final String DUO_AUTH_RESULT_ALLOW = "allow";

    /** Duo AuthAPI auth "deny" result value. */
    @Nonnull @NotEmpty public static final String DUO_AUTH_RESULT_DENY = "deny";

    /** Duo AuthAPI auth "bypass" result value. */
    @Nonnull @NotEmpty public static final String DUO_AUTH_STATUS_BYPASS = "bypass";

    /** Duo AuthAPI auth "locked_out" result value. */
    @Nonnull @NotEmpty public static final String DUO_AUTH_STATUS_LOCKED = "locked_out";
    
    /** Duo response failure status.*/
    @Nonnull @NotEmpty public static final String DUO_RESPONSE_STATUS_FAIL = "FAIL";
    
    /** Duo response success status. */
    @Nonnull @NotEmpty public static final String DUO_RESPONSE_STATUS_OK = "OK";
    
    /** The name of the JSON authentication result object.*/
    @Nonnull @NotEmpty public static final String DUO_AUTH_RESULT_JSON_OBJECT = "auth_result";
    
    /** The name of the JSON result status property.*/
    @Nonnull @NotEmpty public static final String DUO_AUTH_RESULT_STATUS_JSON_OBJECT = "status";
    
    /** The name of the JSON result status message property.*/
    @Nonnull @NotEmpty public static final String DUO_AUTH_RESULT_STATUS_MSG_JSON_OBJECT = "status_msg";
    
    /** The final part of the IdP URL path which is called after authorization.*/
    @Nonnull @NotEmpty public static final String CALLBACK_PATH_SEGMENT = "/duo-callback";
    
    /** The final part of the IdP URL path which is called to begin authorization.*/
    @Nonnull @NotEmpty public static final String AUTHORIZE_PATH_SEGMENT = "/authorize";
    

    /** Constructor. */
    private DuoOIDCAuthAPI() {
    }

}