/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import javax.script.ScriptException;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.ScriptedPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ScriptedPredicateTest {
    private ProfileRequestContext withChild;
    private ProfileRequestContext noChild;

    @BeforeClass
    public void setup() {
        this.withChild = new ProfileRequestContext();
        this.withChild.getSubcontext(RelyingPartyContext.class, true);
        this.noChild = new ProfileRequestContext();
    }

    @Test
    public void simple() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)"new java.lang.Boolean(true);");
        Assert.assertTrue((boolean)test.apply(this.withChild));
        test = ScriptedPredicate.inlineScript((String)"true");
        Assert.assertTrue((boolean)test.apply(this.withChild));
        test = ScriptedPredicate.inlineScript((String)"false");
        Assert.assertFalse((boolean)test.apply(this.withChild));
        test = ScriptedPredicate.inlineScript((String)"\"thirty\"");
        Assert.assertFalse((boolean)test.apply(this.withChild));
    }

    @Test
    public void inlineBean() throws ScriptException {
        GenericApplicationContext ctx = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        beanDefinitionReader.loadBeanDefinitions((Resource)new ClassPathResource("/net/shibboleth/idp/profile/logic/inlineBean.xml"));
        ctx.refresh();
        ScriptedPredicate rule = (ScriptedPredicate)ctx.getBean(ScriptedPredicate.class);
        Assert.assertTrue((boolean)rule.apply(this.withChild));
        Assert.assertFalse((boolean)rule.apply(this.noChild));
    }

    @Test
    public void resourceBean() throws ScriptException {
        GenericApplicationContext ctx = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        beanDefinitionReader.loadBeanDefinitions((Resource)new ClassPathResource("/net/shibboleth/idp/profile/logic/resourceBean.xml"));
        ctx.refresh();
        ScriptedPredicate rule = (ScriptedPredicate)ctx.getBean(ScriptedPredicate.class);
        Assert.assertTrue((boolean)rule.apply(this.withChild));
        Assert.assertFalse((boolean)rule.apply(this.noChild));
    }
}

