/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.ant;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.SelfSignedCertificateGenerator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SelfSignedCertificateGeneratorTask
extends Task {
    private SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();

    public void setKeyType(@Nonnull @NotEmpty String type) {
        this.generator.setKeyType(type);
    }

    public void setKeySize(@Positive int size) {
        this.generator.setKeySize(size);
    }

    public void setCertificateLifetime(@Positive int lifetime) {
        this.generator.setCertificateLifetime(lifetime);
    }

    public void setCertificateAlg(@Nonnull @NotEmpty String alg) {
        this.generator.setCertificateAlg(alg);
    }

    public void setHostName(@Nonnull @NotEmpty String name) {
        this.generator.setHostName(name);
    }

    public void setPrivateKeyFile(@Nullable File file) {
        this.generator.setPrivateKeyFile(file);
    }

    public void setCertificateFile(@Nullable File file) {
        this.generator.setCertificateFile(file);
    }

    public void setKeystoreType(@Nonnull @NotEmpty String type) {
        this.generator.setKeystoreType(type);
    }

    public void setKeystoreFile(@Nullable File file) {
        this.generator.setKeystoreFile(file);
    }

    public void setKeystorePassword(@Nullable String password) {
        this.generator.setKeystorePassword(password);
    }

    public void setDNSSubjectAltNames(@Nonnull @NonnullElements String altNames) {
        List nameList = StringSupport.stringToList((String)altNames, (String)" ");
        this.generator.setDNSSubjectAltNames((Collection)nameList);
    }

    public void setURISubjectAltNames(@Nonnull @NonnullElements String subjectAltNames) {
        List nameList = StringSupport.stringToList((String)subjectAltNames, (String)" ");
        this.generator.setURISubjectAltNames((Collection)nameList);
    }

    public void execute() {
        try {
            this.generator.generate();
        }
        catch (Exception e) {
            this.log("Build failed", e, 0);
            throw new BuildException((Throwable)e);
        }
    }
}

