/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.shibboleth.idp.installer.PropertiesWithComments;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergePropertiesTask
extends Task {
    private File inFile;
    private File outFile;
    private File mergeFile;

    public void setInFile(@Nonnull File what) {
        this.inFile = (File)Constraint.isNotNull((Object)what, (String)"Provided file must not be null");
    }

    public void setOutFile(@Nonnull File what) {
        this.outFile = (File)Constraint.isNotNull((Object)what, (String)"Provided file must not be null");
    }

    public void setMergeFile(@Nonnull File what) {
        this.mergeFile = (File)Constraint.isNotNull((Object)what, (String)"Provided file must not be null");
    }

    public void execute() {
        if (null == this.inFile) {
            this.log("Input file not provided", 0);
            throw new BuildException("Non existant input file");
        }
        if (!this.inFile.exists()) {
            this.log("Input file " + this.inFile.getAbsolutePath() + " does not exist");
            throw new BuildException("Non existant input file");
        }
        if (null == this.outFile) {
            this.log("Output file not provided, input taken", 2);
        }
        if (null == this.mergeFile) {
            this.log("Merge file not provided", 0);
            throw new BuildException("Non existant input file");
        }
        if (!this.mergeFile.exists()) {
            this.log("Input file " + this.mergeFile.getAbsolutePath() + " does not exist");
            throw new BuildException("Non existant merge file");
        }
        PropertiesWithComments in = new PropertiesWithComments();
        try {
            in.load(new FileInputStream(this.inFile));
        }
        catch (IOException e) {
            this.log("Could not load input " + this.inFile.getAbsolutePath(), e, 0);
            throw new BuildException((Throwable)e);
        }
        Properties merge = new Properties();
        try {
            merge.load(new FileInputStream(this.mergeFile));
        }
        catch (IOException e) {
            this.log("Could not load merge " + this.mergeFile.getAbsolutePath(), e, 0);
            throw new BuildException((Throwable)e);
        }
        for (Object propName : merge.keySet()) {
            if (!(propName instanceof String)) continue;
            String name = (String)propName;
            in.replaceProperty(name, merge.getProperty(name));
        }
        try {
            in.store(new FileOutputStream(this.outFile));
        }
        catch (IOException e) {
            this.log("Could not store output " + this.outFile.getAbsolutePath(), e, 0);
            throw new BuildException((Throwable)e);
        }
    }
}

