/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class PropertiesWithComments {
    private List<Object> contents;
    private Map<String, CommentedProperty> properties;

    protected void addCommentedProperty(@Nonnull @NotEmpty String line, boolean isComment) throws IOException {
        Properties parser = new Properties();
        String modifiedLine = isComment ? line.substring(1) : line;
        parser.load(new ByteArrayInputStream(modifiedLine.getBytes()));
        if (!parser.isEmpty()) {
            String propName = StringSupport.trimOrNull((String)parser.stringPropertyNames().iterator().next());
            if (propName != null) {
                CommentedProperty commentedProperty = isComment ? new CommentedProperty(propName, line, true) : new CommentedProperty(propName, parser.getProperty(propName), false);
                this.properties.put(propName, commentedProperty);
                this.contents.add(commentedProperty);
            }
        } else {
            this.contents.add(line);
        }
        parser.clear();
    }

    public void load(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        this.contents = new ArrayList<Object>();
        this.properties = new HashMap<String, CommentedProperty>();
        String s = reader.readLine();
        while (s != null) {
            String what = StringSupport.trimOrNull((String)s);
            if (what == null) {
                this.contents.add("");
            } else if (what.startsWith("#")) {
                if (what.contains("=")) {
                    this.addCommentedProperty(s, true);
                } else {
                    this.contents.add(what);
                }
            } else {
                this.addCommentedProperty(s, false);
            }
            s = reader.readLine();
        }
    }

    public void store(OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        for (Object o : this.contents) {
            if (o instanceof String) {
                writer.write((String)o);
            } else if (o instanceof CommentedProperty) {
                CommentedProperty commentedProperty = (CommentedProperty)o;
                commentedProperty.write(writer);
            }
            writer.newLine();
        }
        writer.flush();
        writer.close();
        output.close();
    }

    public boolean replaceProperty(String propName, String newPropValue) {
        CommentedProperty p = this.properties.get(propName);
        if (null != p) {
            p.setValue(newPropValue);
            return true;
        }
        p = new CommentedProperty(propName, newPropValue, false);
        this.contents.add(p);
        this.properties.put(propName, p);
        return false;
    }

    public void addComment(String what) {
        this.contents.add("# " + what);
    }

    protected class CommentedProperty {
        private final String property;
        private String value;
        private boolean isComment;

        CommentedProperty(String prop, String val, boolean comment) {
            this.property = prop;
            this.value = val;
            this.isComment = comment;
        }

        protected void setValue(String newValue) {
            this.value = newValue;
            this.isComment = false;
        }

        protected void write(BufferedWriter writer) throws IOException {
            if (this.isComment) {
                writer.write(this.value);
            } else {
                writer.write(this.property);
                writer.write("= ");
                writer.write(this.value);
            }
        }
    }
}

