/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent.storage;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.consent.AttributeRelease;
import net.shibboleth.idp.attribute.consent.User;
import net.shibboleth.idp.attribute.consent.storage.Storage;
import org.joda.time.DateTime;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JDBCStorage
implements Storage {
    private SimpleJdbcTemplate jdbcTemplate;
    private final UserMapper userMapper = new UserMapper();
    private final AttributeReleaseMapper attributeReleaseMapper = new AttributeReleaseMapper();
    private final String userTable = "User";
    private final String attributeReleaseTable = "AttributeRelease";

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Override
    public boolean containsUser(String userId) {
        String sql = " SELECT COUNT(*) FROM User WHERE id = ?";
        return this.jdbcTemplate.queryForInt(" SELECT COUNT(*) FROM User WHERE id = ?", new Object[]{userId}) > 0;
    }

    @Override
    public User readUser(String userId) {
        String sql = "SELECT id, globalConsent FROM User WHERE id = ?";
        try {
            return (User)this.jdbcTemplate.queryForObject("SELECT id, globalConsent FROM User WHERE id = ?", (RowMapper)this.userMapper, new Object[]{userId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public void updateUser(User user) {
        String sql = "UPDATE User SET globalConsent = ? WHERE id = ?";
        this.jdbcTemplate.update("UPDATE User SET globalConsent = ? WHERE id = ?", new Object[]{user.hasGlobalConsent(), user.getId()});
    }

    @Override
    public void createUser(User user) {
        String sql = "INSERT INTO User (id, globalConsent) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO User (id, globalConsent) VALUES (?, ?)", new Object[]{user.getId(), user.hasGlobalConsent()});
    }

    @Override
    public Collection<AttributeRelease> readAttributeReleases(String userId, String relyingPartyId) {
        String sql = "SELECT attributeId, valuesHash, consentDate FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ?";
        try {
            return this.jdbcTemplate.query("SELECT attributeId, valuesHash, consentDate FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ?", (RowMapper)this.attributeReleaseMapper, new Object[]{userId, relyingPartyId});
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public void deleteAttributeReleases(String userId, String relyingPartyId) {
        String sql = "DELETE FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ?";
        this.jdbcTemplate.update("DELETE FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ?", new Object[]{userId, relyingPartyId});
    }

    @Override
    public boolean containsAttributeRelease(String userId, String relyingPartyId, String attributeId) {
        String sql = " SELECT COUNT(*) FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ? AND attributeId =?";
        return this.jdbcTemplate.queryForInt(" SELECT COUNT(*) FROM AttributeRelease WHERE userId = ? AND relyingPartyId = ? AND attributeId =?", new Object[]{userId, relyingPartyId, attributeId}) > 0;
    }

    @Override
    public void updateAttributeRelease(String userId, String relyingPartyId, AttributeRelease attributeRelease) {
        String sql = "UPDATE AttributeRelease SET valuesHash = ?, consentDate = ? WHERE userId = ? AND relyingPartyId = ? AND attributeId = ?";
        this.jdbcTemplate.update("UPDATE AttributeRelease SET valuesHash = ?, consentDate = ? WHERE userId = ? AND relyingPartyId = ? AND attributeId = ?", new Object[]{attributeRelease.getValuesHash(), attributeRelease.getDate().toDate(), userId, relyingPartyId, attributeRelease.getAttributeId()});
    }

    @Override
    public void createAttributeRelease(String userId, String relyingPartyId, AttributeRelease attributeRelease) {
        String sql = "INSERT INTO AttributeRelease (userId, relyingPartyId, attributeId, valuesHash, consentDate) VALUES (?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO AttributeRelease (userId, relyingPartyId, attributeId, valuesHash, consentDate) VALUES (?, ?, ?, ?, ?)", new Object[]{userId, relyingPartyId, attributeRelease.getAttributeId(), attributeRelease.getValuesHash(), attributeRelease.getDate().toDate()});
    }

    private static final class AttributeReleaseMapper
    implements RowMapper<AttributeRelease> {
        private AttributeReleaseMapper() {
        }

        public AttributeRelease mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new AttributeRelease(rs.getString("attributeId"), rs.getString("valuesHash"), new DateTime((Object)rs.getTimestamp("consentDate")));
        }
    }

    private static final class UserMapper
    implements RowMapper<User> {
        private UserMapper() {
        }

        public final User mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new User(rs.getString("id"), rs.getBoolean("globalConsent"));
        }
    }
}

