/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import net.shibboleth.idp.attribute.consent.AttributeRelease;
import net.shibboleth.idp.attribute.consent.User;
import net.shibboleth.idp.attribute.consent.storage.Storage;
import net.shibboleth.idp.storage.Cache;
import net.shibboleth.idp.storage.CacheManager;
import net.shibboleth.idp.storage.Configuration;
import org.springframework.util.Assert;

public class CacheStorage
implements Storage {
    @Resource(name="cacheManager")
    private CacheManager cacheManager;
    private ConcurrentMap<String, User> userPartition;
    private ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, AttributeRelease>>> attributeReleasePartition;

    public void initialize() {
        Cache cache = this.cacheManager.getCache("consent");
        if (cache == null) {
            this.cacheManager.defineConfiguration("consent", new Configuration());
            cache = this.cacheManager.getCache("consent");
        }
        cache.putIfAbsent("userPartition", new ConcurrentHashMap());
        cache.putIfAbsent("attributeReleasePartition", new ConcurrentHashMap());
        this.userPartition = (ConcurrentMap)cache.get("userPartition");
        this.attributeReleasePartition = (ConcurrentMap)cache.get("attributeReleasePartition");
    }

    @Override
    public boolean containsUser(String userId) {
        return this.userPartition.containsKey(userId);
    }

    @Override
    public User readUser(String userId) {
        return (User)this.userPartition.get(userId);
    }

    @Override
    public void updateUser(User user) {
        this.userPartition.replace(user.getId(), user);
    }

    @Override
    public void createUser(User user) {
        this.userPartition.put(user.getId(), user);
    }

    @Override
    public Collection<AttributeRelease> readAttributeReleases(String userId, String relyingPartyId) {
        if (!this.attributeReleasePartition.containsKey(userId)) {
            return Collections.EMPTY_SET;
        }
        if (!((ConcurrentMap)this.attributeReleasePartition.get(userId)).containsKey(relyingPartyId)) {
            return Collections.EMPTY_SET;
        }
        return ((ConcurrentMap)((ConcurrentMap)this.attributeReleasePartition.get(userId)).get(relyingPartyId)).values();
    }

    @Override
    public void deleteAttributeReleases(String userId, String relyingPartyId) {
        if (this.attributeReleasePartition.containsKey(userId)) {
            ((ConcurrentMap)this.attributeReleasePartition.get(userId)).remove(relyingPartyId);
        }
    }

    @Override
    public boolean containsAttributeRelease(String userId, String relyingPartyId, String attributeId) {
        if (!this.attributeReleasePartition.containsKey(userId)) {
            return false;
        }
        if (!((ConcurrentMap)this.attributeReleasePartition.get(userId)).containsKey(relyingPartyId)) {
            return false;
        }
        return ((ConcurrentMap)((ConcurrentMap)this.attributeReleasePartition.get(userId)).get(relyingPartyId)).containsKey(attributeId);
    }

    @Override
    public void updateAttributeRelease(String userId, String relyingPartyId, AttributeRelease attributeRelease) {
        Assert.state((boolean)this.attributeReleasePartition.containsKey(userId));
        Assert.state((boolean)((ConcurrentMap)this.attributeReleasePartition.get(userId)).containsKey(relyingPartyId));
        ((ConcurrentMap)((ConcurrentMap)this.attributeReleasePartition.get(userId)).get(relyingPartyId)).replace(attributeRelease.getAttributeId(), attributeRelease);
    }

    @Override
    public void createAttributeRelease(String userId, String relyingPartyId, AttributeRelease attributeRelease) {
        this.attributeReleasePartition.putIfAbsent(userId, new ConcurrentHashMap());
        ((ConcurrentMap)this.attributeReleasePartition.get(userId)).putIfAbsent(relyingPartyId, new ConcurrentHashMap());
        ((ConcurrentMap)((ConcurrentMap)this.attributeReleasePartition.get(userId)).get(relyingPartyId)).put(attributeRelease.getAttributeId(), attributeRelease);
    }
}

