/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.consent.AttributeRelease;

@NotThreadSafe
public class User {
    private final String id;
    private boolean globalConsent;
    private final Map<String, Collection<AttributeRelease>> releases;

    public User(String userId, boolean globalConsentGiven) {
        this.id = userId;
        this.globalConsent = globalConsentGiven;
        this.releases = new HashMap<String, Collection<AttributeRelease>>();
    }

    public boolean hasGlobalConsent() {
        return this.globalConsent;
    }

    public void setGlobalConsent(boolean globalConsentGiven) {
        this.globalConsent = globalConsentGiven;
    }

    public String getId() {
        return this.id;
    }

    public void setAttributeReleases(String relyingPartyId, Collection<AttributeRelease> attributeReleases) {
        this.releases.put(relyingPartyId, attributeReleases);
    }

    public Collection<AttributeRelease> getAttributeReleases(String relyingPartyId) {
        if (!this.releases.containsKey(relyingPartyId)) {
            return Collections.EMPTY_SET;
        }
        return this.releases.get(relyingPartyId);
    }

    public boolean hasApprovedAttributes(String relyingPartyId, Collection<IdPAttribute> attributes) {
        Collection<AttributeRelease> attributeReleases = this.getAttributeReleases(relyingPartyId);
        for (IdPAttribute attribute : attributes) {
            boolean approved = false;
            for (AttributeRelease attributeRelease : attributeReleases) {
                if (!attributeRelease.contains(attribute)) continue;
                approved = true;
                break;
            }
            if (approved) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.id;
    }
}

