/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceDescription;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@NotThreadSafe
public class LocalizationHelper {
    private final Logger logger = LoggerFactory.getLogger(LocalizationHelper.class);
    private Locale preferredLocale;
    private boolean localeEnforcement;
    private MetadataResolver metadataResolver;

    public void setPreferredLocale(Locale newPreferredLocale) {
        this.preferredLocale = newPreferredLocale;
    }

    public void setLocaleEnforcement(boolean localeEnforced) {
        this.localeEnforcement = localeEnforced;
    }

    public void setMetadataProvider(MetadataResolver newMetadataProvider) {
        this.metadataResolver = newMetadataProvider;
    }

    public String getRelyingPartyName(String relyingPartyId, Locale userLocale) {
        List<ServiceName> serviceNames = this.getServiceNames(relyingPartyId);
        Locale locale = this.selectLocale(this.getAvailableNameLocales(serviceNames), userLocale);
        if (locale == null) {
            return relyingPartyId;
        }
        return this.getRelyingPartyName(serviceNames, locale);
    }

    public String getRelyingPartyDescription(String relyingPartyId, Locale userLocale) {
        List<ServiceDescription> serviceDescription = this.getServiceDescriptions(relyingPartyId);
        Locale locale = this.selectLocale(this.getAvailableDescriptionLocales(serviceDescription), userLocale);
        if (locale == null) {
            return "";
        }
        return this.getRelyingPartyDescription(serviceDescription, locale);
    }

    public String getAttributeName(IdPAttribute attribute, Locale userLocale) {
        Locale locale = this.selectLocale(attribute.getDisplayNames().keySet(), userLocale);
        this.logger.debug("Locale {} choosen for attribute {} name", (Object)locale, (Object)attribute.getId());
        if (locale == null) {
            return attribute.getId();
        }
        return (String)attribute.getDisplayNames().get(locale);
    }

    public String getAttributeDescription(IdPAttribute attribute, Locale userLocale) {
        Locale locale = this.selectLocale(attribute.getDisplayDescriptions().keySet(), userLocale);
        this.logger.debug("Locale {} choosen for attribute {} description", (Object)locale, (Object)attribute.getId());
        if (locale == null) {
            return "";
        }
        return (String)attribute.getDisplayDescriptions().get(locale);
    }

    public Locale selectLocale(Collection<Locale> availableLocales, Locale userLocale) {
        if (this.localeEnforcement) {
            if (availableLocales.contains(this.preferredLocale)) {
                this.logger.debug("Locale {} is enforced and available", (Object)this.preferredLocale);
                return this.preferredLocale;
            }
            this.logger.debug("Locale {} is enforced but not available", (Object)this.preferredLocale);
            return null;
        }
        if (availableLocales.contains(userLocale)) {
            this.logger.debug("User's locale {} is available", (Object)userLocale);
            return userLocale;
        }
        if (availableLocales.contains(this.preferredLocale)) {
            this.logger.debug("Preferred locale {} is available", (Object)this.preferredLocale);
            return this.preferredLocale;
        }
        this.logger.debug("Neither user's locale {} nor preferred locale {} is available", (Object)userLocale, (Object)this.preferredLocale);
        return null;
    }

    private Collection<Locale> getAvailableNameLocales(List<ServiceName> serviceNames) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (ServiceName serviceName : serviceNames) {
            availableLocales.add(new Locale(serviceName.getXMLLang()));
        }
        return availableLocales;
    }

    private Collection<Locale> getAvailableDescriptionLocales(List<ServiceDescription> serviceDescriptions) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (ServiceDescription serviceDescription : serviceDescriptions) {
            availableLocales.add(new Locale(serviceDescription.getXMLLang()));
        }
        return availableLocales;
    }

    private String getRelyingPartyName(List<ServiceName> serviceNames, Locale locale) {
        for (ServiceName serviceName : serviceNames) {
            if (!serviceName.getXMLLang().equals(locale.getLanguage())) continue;
            return serviceName.getXMLLang();
        }
        return null;
    }

    private String getRelyingPartyDescription(List<ServiceDescription> serviceDescriptions, Locale locale) {
        for (ServiceDescription serviceDescription : serviceDescriptions) {
            if (!serviceDescription.getXMLLang().equals(locale.getLanguage())) continue;
            return serviceDescription.getXMLLang();
        }
        return null;
    }

    private List<ServiceName> getServiceNames(String entityId) {
        AttributeConsumingService attributeConsumingService = this.getAttributeConsumingService(entityId);
        if (attributeConsumingService != null) {
            return attributeConsumingService.getNames();
        }
        return Collections.EMPTY_LIST;
    }

    private List<ServiceDescription> getServiceDescriptions(String entityId) {
        AttributeConsumingService attributeConsumingService = this.getAttributeConsumingService(entityId);
        if (attributeConsumingService != null) {
            return attributeConsumingService.getDescriptions();
        }
        return Collections.EMPTY_LIST;
    }

    private AttributeConsumingService getAttributeConsumingService(String entityId) {
        String[] protocols;
        Assert.notNull((Object)this.metadataResolver);
        EntityDescriptor entityDescriptor = null;
        try {
            entityDescriptor = (EntityDescriptor)this.metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId)}));
        }
        catch (ResolverException e) {
            this.logger.warn("Unable to retrieve relying party description for {}", (Object)entityId, (Object)e);
            return null;
        }
        for (String protocol : protocols = new String[]{"urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol", "urn:oasis:names:tc:SAML:1.0:protocol"}) {
            SPSSODescriptor spSSODescriptor = entityDescriptor.getSPSSODescriptor(protocol);
            if (spSSODescriptor == null) continue;
            AttributeConsumingService defaultAttributeConsumingService = spSSODescriptor.getDefaultAttributeConsumingService();
            if (defaultAttributeConsumingService != null) {
                return defaultAttributeConsumingService;
            }
            List list = spSSODescriptor.getAttributeConsumingServices();
            if (list == null || list.isEmpty()) continue;
            return (AttributeConsumingService)list.get(0);
        }
        return null;
    }
}

