/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.consent.AttributeRelease;
import net.shibboleth.idp.attribute.consent.ConsentContext;
import net.shibboleth.idp.attribute.consent.ConsentHelper;
import net.shibboleth.idp.attribute.consent.LocalizationHelper;
import net.shibboleth.idp.attribute.consent.User;
import net.shibboleth.idp.attribute.consent.storage.Storage;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentServlet
extends HttpServlet {
    public static final String USER_KEY = "consent.key.user";
    public static final String RELYINGPARTYID_KEY = "consent.key.relyingPartyId";
    public static final String ATTRIBUTES_KEY = "consent.key.attributes";
    private static final long serialVersionUID = 2763387866916451439L;
    private final Logger logger = LoggerFactory.getLogger(ConsentServlet.class);
    @Resource(name="consent.storage")
    private Storage storage;
    @Resource(name="consent.config.localizationHelper")
    private LocalizationHelper localizationHelper;
    @Resource(name="consent.config.globalConsentEnabled")
    private boolean globalConsentEnabled;
    @Resource(name="consent.config.attributeSortOrder")
    private List<String> attributeSortOrder;
    @Resource(name="velocityEngine")
    private VelocityEngine velocityEngine;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relyingPartyId = (String)request.getAttribute(RELYINGPARTYID_KEY);
        Collection attributes = (Collection)request.getAttribute(ATTRIBUTES_KEY);
        String resourceName = this.localizationHelper.getRelyingPartyName(relyingPartyId, request.getLocale());
        String resourceDescription = this.localizationHelper.getRelyingPartyDescription(relyingPartyId, request.getLocale());
        SortedSet<IdPAttribute> sortedAttributes = ConsentHelper.sortAttributes(this.attributeSortOrder, attributes);
        List<DisplayAttribute> displayAttributes = this.createDisplayAttributes(sortedAttributes, request.getLocale());
        VelocityContext context = new VelocityContext();
        context.put("resourceName", (Object)resourceName);
        context.put("resourceDescription", (Object)resourceDescription);
        context.put("displayAttributes", displayAttributes);
        context.put("globalConsentEnabled", (Object)this.globalConsentEnabled);
        try {
            this.velocityEngine.mergeTemplate("attribute-release.vm", "UTF-8", (Context)context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new ServletException("Unable to call velocity engine", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean accepted;
        ConsentContext consentContext = ConsentHelper.getConsentContext(request);
        User user = (User)request.getAttribute(USER_KEY);
        String relyingPartyId = (String)request.getAttribute(RELYINGPARTYID_KEY);
        Collection attributes = (Collection)request.getAttribute(ATTRIBUTES_KEY);
        boolean bl = accepted = request.getParameter("consent.accept") != null && request.getParameter("consent.accept").equals("yes");
        if (accepted) {
            boolean globalConsent;
            this.logger.debug("User {} accepted attribute release for relying party {}", (Object)user, (Object)relyingPartyId);
            DateTime consentDate = new DateTime();
            user.setAttributeReleases(relyingPartyId, AttributeRelease.createAttributeReleases(attributes, consentDate));
            boolean bl2 = globalConsent = request.getParameter("consent.global") != null && request.getParameter("consent.global").equals("yes");
            if (this.globalConsentEnabled && globalConsent) {
                this.logger.debug("User {} has given global consent", (Object)user);
                user.setGlobalConsent(true);
            }
            if (this.storage.containsUser(user.getId())) {
                this.storage.updateUser(user);
            } else {
                this.storage.createUser(user);
            }
            for (AttributeRelease attributeRelease : user.getAttributeReleases(relyingPartyId)) {
                if (this.storage.containsAttributeRelease(user.getId(), relyingPartyId, attributeRelease.getAttributeId())) {
                    this.storage.updateAttributeRelease(user.getId(), relyingPartyId, attributeRelease);
                    continue;
                }
                this.storage.createAttributeRelease(user.getId(), relyingPartyId, attributeRelease);
            }
            consentContext.setConsentDecision(ConsentContext.Consent.OBTAINED);
        } else {
            this.logger.debug("User {} declined attribute release for relying party {}", (Object)user, (Object)relyingPartyId);
            consentContext.setConsentDecision(ConsentContext.Consent.DENIED);
        }
    }

    private List<DisplayAttribute> createDisplayAttributes(Collection<IdPAttribute> attributes, Locale locale) {
        ArrayList<DisplayAttribute> displayAttributes = new ArrayList<DisplayAttribute>();
        for (IdPAttribute attribute : attributes) {
            displayAttributes.add(new DisplayAttribute(attribute, locale));
        }
        return displayAttributes;
    }

    public class DisplayAttribute {
        private final String name;
        private final String description;
        private final Collection<?> values;

        public DisplayAttribute(IdPAttribute attribute, Locale locale) {
            this.name = ConsentServlet.this.localizationHelper.getAttributeName(attribute, locale);
            this.description = ConsentServlet.this.localizationHelper.getAttributeDescription(attribute, locale);
            this.values = attribute.getValues();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<?> getValues() {
            return this.values;
        }
    }
}

