/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.consent.ConsentContext;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.HashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConsentHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsentHelper.class);

    private ConsentHelper() {
    }

    public static String getRelyingParty(ConsentContext context) {
        return null;
    }

    public static boolean isConsentRevocationRequested(ConsentContext consentContext) {
        return false;
    }

    public static String hashAttributeValues(IdPAttribute attribute) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(attribute.getValues());
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("Error while converting attribute values into a byte array", (Throwable)e);
            return null;
        }
        return CodecUtil.hex((byte[])HashUtil.sha256((Object[])new Object[]{byteArrayOutputStream.toByteArray()}), (boolean)true);
    }

    public static final String findUserId(String userIdAttribute, Collection<IdPAttribute> releasedAttributes) {
        for (IdPAttribute releasedAttribute : releasedAttributes) {
            if (!releasedAttribute.getId().equals(userIdAttribute)) continue;
            Set userIdAttributeValues = releasedAttribute.getValues();
            if (userIdAttributeValues.isEmpty()) {
                LOGGER.error("uniqueId attribute {} contains no values.", (Object)userIdAttribute);
                return null;
            }
            if (userIdAttributeValues.size() > 1) {
                LOGGER.warn("uniqueId attribute {} has more than one value {}. Select first.", (Object)userIdAttribute, (Object)userIdAttributeValues);
            }
            return String.valueOf(userIdAttributeValues.iterator().next());
        }
        LOGGER.error("uniqueId attribute {} will not be released", (Object)userIdAttribute);
        return null;
    }

    public static boolean skipRelyingParty(Collection<String> list, boolean isBlacklist, String relyingPartyId) {
        boolean found = false;
        for (String regex : list) {
            Pattern pattern = Pattern.compile(regex);
            if (!pattern.matcher(relyingPartyId).find()) continue;
            found = true;
            break;
        }
        return isBlacklist ? found : !found;
    }

    public static Collection<IdPAttribute> removeBlacklistedAttributes(Collection<String> blacklist, Collection<IdPAttribute> allAttributes) {
        HashSet<IdPAttribute> attributes = new HashSet<IdPAttribute>();
        for (IdPAttribute attribute : allAttributes) {
            if (blacklist.contains(attribute.getId())) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public static SortedSet<IdPAttribute> sortAttributes(List<String> sortOrder, Collection<IdPAttribute> releasedAttributes) {
        return new SortedAttributeSet(sortOrder, releasedAttributes);
    }

    public static ConsentContext getConsentContext(HttpServletRequest request) {
        return null;
    }

    public static HttpServletRequest getRequest(ConsentContext consentContext) {
        return null;
    }

    public static HttpServletResponse getResponse(ConsentContext consentContext) {
        return null;
    }

    private static class SortedAttributeSet
    extends TreeSet<IdPAttribute> {
        private static final long serialVersionUID = -9035171496036683394L;

        public SortedAttributeSet(final List<String> sortOrder, Collection<IdPAttribute> attributes) {
            super(new Comparator<IdPAttribute>(){

                @Override
                public int compare(IdPAttribute attribute1, IdPAttribute attribute2) {
                    int last = sortOrder.size();
                    int rank1 = sortOrder.indexOf(attribute1.getId());
                    int rank2 = sortOrder.indexOf(attribute2.getId());
                    if (rank2 < 0) {
                        rank2 = last++;
                    }
                    if (rank1 < 0) {
                        rank1 = last++;
                    }
                    return rank1 - rank2;
                }
            });
            this.addAll(attributes);
        }
    }
}

