/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.consent.AttributeRelease;
import net.shibboleth.idp.attribute.consent.ConsentContext;
import net.shibboleth.idp.attribute.consent.ConsentEngine;
import net.shibboleth.idp.attribute.consent.ConsentException;
import net.shibboleth.idp.attribute.consent.ConsentHelper;
import net.shibboleth.idp.attribute.consent.User;
import net.shibboleth.idp.attribute.consent.storage.Storage;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ConsentEngineImpl
implements ConsentEngine {
    private final Logger logger = LoggerFactory.getLogger(ConsentEngineImpl.class);
    @Resource(name="consent.storage")
    private Storage storage;
    @Resource(name="consent.config.relyingPartyWhiteBlackList")
    private Collection<String> relyingPartyWhiteBlackList;
    @Resource(name="consent.config.relyingPartyWhiteBlackList.isBlacklist")
    private boolean relyingPartyWhiteBlackListIsBlacklist;
    @Resource(name="consent.config.attributeBlacklist")
    private Collection<String> attributeBlacklist;
    @Resource(name="consent.config.userIdAttribute")
    private String userIdAttribute;
    @Resource(name="consent.config.alwaysRequireConsent")
    private boolean alwaysRequireConsent;

    public void determineConsent(ConsentContext consentContext) throws ConsentException {
        Assert.notNull((Object)consentContext, (String)"No consent context found");
        Assert.state((boolean)consentContext.getParent().getClass().equals(ProfileRequestContext.class), (String)"Owner of a consent context must be a profile context");
        String relyingPartyId = ConsentHelper.getRelyingParty(consentContext);
        Collection<IdPAttribute> attributes = consentContext.getUserIdPAttributes().values();
        String userId = ConsentHelper.findUserId(this.userIdAttribute, attributes);
        Assert.notNull((Object)userId, (String)"No userId found");
        this.logger.debug("Using {}({}) as userId attribute", (Object)this.userIdAttribute, (Object)userId);
        User user = this.createUser(userId, relyingPartyId);
        boolean consentRevocationRequested = ConsentHelper.isConsentRevocationRequested(consentContext);
        if (consentRevocationRequested) {
            user.setGlobalConsent(false);
            user.setAttributeReleases(relyingPartyId, Collections.EMPTY_SET);
            this.storage.deleteAttributeReleases(user.getId(), relyingPartyId);
        }
        if (user.hasGlobalConsent()) {
            this.logger.info("user {} has given global consent", (Object)user);
            consentContext.setConsentDecision(ConsentContext.Consent.PRIOR);
            return;
        }
        if (ConsentHelper.skipRelyingParty(this.relyingPartyWhiteBlackList, this.relyingPartyWhiteBlackListIsBlacklist, relyingPartyId)) {
            this.logger.info("Skip relying party {}", (Object)relyingPartyId);
            consentContext.setConsentDecision(ConsentContext.Consent.UNSPECIFIED);
            return;
        }
        attributes = ConsentHelper.removeBlacklistedAttributes(this.attributeBlacklist, attributes);
        this.logger.debug("Blacklisted attributes are removed from the release set, considered attributes are {}", attributes);
        if (attributes.isEmpty()) {
            this.logger.info("No attributes of user {} for relying party {} are released", (Object)user, (Object)relyingPartyId);
            consentContext.setConsentDecision(ConsentContext.Consent.INAPPLICABLE);
            return;
        }
        if (this.alwaysRequireConsent) {
            this.logger.debug("Always require consent is enabled");
            this.showAttributeReleaseView(consentContext, user, relyingPartyId, attributes);
            return;
        }
        if (user.hasGlobalConsent()) {
            this.logger.info("User {} has given global consent", (Object)user);
            consentContext.setConsentDecision(ConsentContext.Consent.PRIOR);
            return;
        }
        if (user.hasApprovedAttributes(relyingPartyId, attributes)) {
            this.logger.info("User {} has appoved set of attributes for relying party {}", (Object)user, (Object)relyingPartyId);
            consentContext.setConsentDecision(ConsentContext.Consent.PRIOR);
            return;
        }
        this.showAttributeReleaseView(consentContext, user, relyingPartyId, attributes);
    }

    private void showAttributeReleaseView(ConsentContext consentContext, User user, String relyingPartyId, Collection<IdPAttribute> attributes) {
        HttpServletRequest request = ConsentHelper.getRequest(consentContext);
        HttpServletResponse response = ConsentHelper.getResponse(consentContext);
        request.setAttribute("consent.key.user", (Object)user);
        request.setAttribute("consent.key.relyingPartyId", (Object)relyingPartyId);
        request.setAttribute("consent.key.attributes", attributes);
        this.logger.debug("Dispatch to attribute release view");
        try {
            request.getRequestDispatcher("attribute-release").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            this.logger.error("Error while dispatching to attribute release view", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Error while dispatching to attribute release view", (Throwable)e);
        }
    }

    private User createUser(String userId, String relyingPartyId) {
        User user;
        if (this.storage.containsUser(userId)) {
            user = this.storage.readUser(userId);
            Collection<AttributeRelease> attributeRelease = this.storage.readAttributeReleases(userId, relyingPartyId);
            user.setAttributeReleases(relyingPartyId, attributeRelease);
        } else {
            user = new User(userId, false);
            user.setAttributeReleases(relyingPartyId, Collections.EMPTY_SET);
        }
        return user;
    }
}

