/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.consent;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.consent.ConsentHelper;
import org.joda.time.DateTime;

@ThreadSafe
public class AttributeRelease {
    private final String attributeId;
    private final String valuesHash;
    private final DateTime consentDate;

    public AttributeRelease(String attributeId, String valuesHash, DateTime consentDate) {
        this.attributeId = attributeId;
        this.valuesHash = valuesHash;
        this.consentDate = consentDate;
    }

    private AttributeRelease(IdPAttribute attribute, DateTime consentDate) {
        this.attributeId = attribute.getId();
        this.valuesHash = ConsentHelper.hashAttributeValues(attribute);
        this.consentDate = consentDate;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public String getValuesHash() {
        return this.valuesHash;
    }

    public DateTime getDate() {
        return this.consentDate;
    }

    public static Collection<AttributeRelease> createAttributeReleases(Collection<IdPAttribute> attributes, DateTime date) {
        HashSet<AttributeRelease> attributeReleases = new HashSet<AttributeRelease>();
        for (IdPAttribute attribute : attributes) {
            attributeReleases.add(new AttributeRelease(attribute, date));
        }
        return attributeReleases;
    }

    public boolean contains(IdPAttribute attribute) {
        return this.attributeId.equals(attribute.getId()) && this.valuesHash.equals(ConsentHelper.hashAttributeValues(attribute));
    }
}

