/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.util.Arrays;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationContextTest {
    @Test
    public void testInitiationInstant() throws Exception {
        long start = System.currentTimeMillis();
        Thread.sleep(50L);
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((ctx.getInitiationInstant() > start ? 1 : 0) != 0);
    }

    @Test
    public void testForcingAuthentication() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertFalse((boolean)ctx.isForceAuthn());
        ctx.setForceAuthn(true);
        Assert.assertTrue((boolean)ctx.isForceAuthn());
    }

    @Test
    public void testActiveResults() throws Exception {
        AuthenticationResult result = new AuthenticationResult("test", new Subject());
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((boolean)ctx.getActiveResults().isEmpty());
        ctx.setActiveResults(Arrays.asList(result));
        Assert.assertEquals((int)ctx.getActiveResults().size(), (int)1);
        Assert.assertEquals(ctx.getActiveResults().get("test"), (Object)result);
    }

    @Test
    public void testPotentialFlows() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertTrue((boolean)ctx.getPotentialFlows().isEmpty());
        AuthenticationFlowDescriptor descriptor = new AuthenticationFlowDescriptor();
        descriptor.setId("test");
        ctx = new AuthenticationContext();
        ctx.getPotentialFlows().put(descriptor.getId(), descriptor);
        Assert.assertEquals((int)ctx.getPotentialFlows().size(), (int)1);
        Assert.assertEquals(ctx.getPotentialFlows().get("test"), (Object)descriptor);
    }

    @Test
    public void testAttemptedFlow() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertNull((Object)ctx.getAttemptedFlow());
        AuthenticationFlowDescriptor descriptor = new AuthenticationFlowDescriptor();
        descriptor.setId("test");
        ctx.setAttemptedFlow(descriptor);
        Assert.assertEquals((Object)ctx.getAttemptedFlow(), (Object)descriptor);
    }

    @Test
    public void testCompletionInstant() throws Exception {
        AuthenticationContext ctx = new AuthenticationContext();
        Assert.assertEquals((long)ctx.getCompletionInstant(), (long)0L);
        long now = System.currentTimeMillis();
        Thread.sleep(50L);
        ctx.setCompletionInstant();
        Assert.assertTrue((ctx.getCompletionInstant() > now ? 1 : 0) != 0);
    }
}

