/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.security.Principal;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationResultTest {
    @Test
    public void testInstantiation() throws Exception {
        long start = System.currentTimeMillis();
        Thread.sleep(50L);
        AuthenticationResult event = new AuthenticationResult("test", (Principal)new UsernamePrincipal("bob"));
        Assert.assertTrue((event.getAuthenticationInstant() > start ? 1 : 0) != 0);
        Assert.assertEquals((String)event.getAuthenticationFlowId(), (String)"test");
        Assert.assertTrue((boolean)event.getSubject().getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("bob")));
        try {
            new AuthenticationResult(null, (Principal)new UsernamePrincipal("bob"));
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            new AuthenticationResult("", (Principal)new UsernamePrincipal("bob"));
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            new AuthenticationResult("  ", (Principal)new UsernamePrincipal("bob"));
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            new AuthenticationResult("test", (Subject)null);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }
}

