/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.security.Principal;
import java.util.Arrays;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthenticationFlowDescriptorTest {
    private AuthenticationFlowDescriptor descriptor;

    @BeforeMethod
    public void setUp() {
        this.descriptor = new AuthenticationFlowDescriptor();
        this.descriptor.setId("test");
    }

    @Test
    public void testInstantation() {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertFalse((boolean)this.descriptor.isForcedAuthenticationSupported());
        Assert.assertFalse((boolean)this.descriptor.isPassiveAuthenticationSupported());
    }

    @Test
    public void testLifetime() {
        this.descriptor.setLifetime(10L);
        Assert.assertEquals((long)this.descriptor.getLifetime(), (long)10L);
        try {
            this.descriptor.setLifetime(-10L);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((long)this.descriptor.getLifetime(), (long)10L);
        }
    }

    @Test
    public void testInactivityTimeout() {
        this.descriptor.setInactivityTimeout(10L);
        Assert.assertEquals((long)this.descriptor.getInactivityTimeout(), (long)10L);
        try {
            this.descriptor.setInactivityTimeout(-10L);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((long)this.descriptor.getInactivityTimeout(), (long)10L);
        }
    }

    @Test
    public void testSupportedForcedAuthentication() {
        this.descriptor.setForcedAuthenticationSupported(true);
        Assert.assertTrue((boolean)this.descriptor.isForcedAuthenticationSupported());
        this.descriptor.setForcedAuthenticationSupported(false);
        Assert.assertFalse((boolean)this.descriptor.isForcedAuthenticationSupported());
    }

    @Test
    public void testSupportedPassiveAuthentication() {
        this.descriptor.setPassiveAuthenticationSupported(true);
        Assert.assertTrue((boolean)this.descriptor.isPassiveAuthenticationSupported());
        this.descriptor.setPassiveAuthenticationSupported(false);
        Assert.assertFalse((boolean)this.descriptor.isPassiveAuthenticationSupported());
    }

    @Test
    public void testSupportedPrincipals() {
        Assert.assertTrue((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).isEmpty());
        UsernamePrincipal foo = new UsernamePrincipal("foo");
        UsernamePrincipal bar = new UsernamePrincipal("bar");
        UsernamePrincipal baz = new UsernamePrincipal("baz");
        this.descriptor.setSupportedPrincipals(Arrays.asList(foo));
        Assert.assertEquals((int)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).size(), (int)1);
        Assert.assertTrue((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).contains(foo));
        this.descriptor.setSupportedPrincipals(Arrays.asList(foo, bar));
        Assert.assertEquals((int)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).size(), (int)2);
        Assert.assertTrue((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).contains(foo));
        Assert.assertTrue((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).contains(bar));
        Assert.assertFalse((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).contains(baz));
        this.descriptor.getSupportedPrincipals().add(baz);
        Assert.assertEquals((int)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).size(), (int)3);
        Assert.assertTrue((boolean)this.descriptor.getSupportedPrincipals(UsernamePrincipal.class).contains(baz));
        try {
            this.descriptor.getSupportedPrincipals().add(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testActiveResults() throws InterruptedException {
        AuthenticationResult result = new AuthenticationResult("test", (Principal)new UsernamePrincipal("foo"));
        Assert.assertTrue((boolean)this.descriptor.isResultActive(result));
        Thread.sleep(20L);
        this.descriptor.setLifetime(10L);
        Assert.assertFalse((boolean)this.descriptor.isResultActive(result));
        this.descriptor.setLifetime(5000L);
        Assert.assertTrue((boolean)this.descriptor.isResultActive(result));
        Thread.sleep(20L);
        this.descriptor.setInactivityTimeout(10L);
        Assert.assertFalse((boolean)this.descriptor.isResultActive(result));
        result.setLastActivityInstantToNow();
        Assert.assertTrue((boolean)this.descriptor.isResultActive(result));
    }
}

