/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.threading;

import com.google.inject.Inject;
import io.relution.jenkins.scmsqs.interfaces.SQSFactory;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueListener;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueMonitor;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueMonitorScheduler;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueProvider;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.util.ThrowIf;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class SQSQueueMonitorSchedulerImpl
implements SQSQueueMonitorScheduler {
    private final ExecutorService executor;
    private final SQSQueueProvider provider;
    private final SQSFactory factory;
    private final Map<String, SQSQueueMonitor> monitors = new HashMap<String, SQSQueueMonitor>();

    @Inject
    public SQSQueueMonitorSchedulerImpl(ExecutorService executor, SQSQueueProvider provider, SQSFactory factory) {
        this.executor = executor;
        this.provider = provider;
        this.factory = factory;
    }

    @Override
    public boolean register(SQSQueueListener listener) {
        ThrowIf.isNull(listener, "listener");
        Log.info("Register SQS listener", new Object[0]);
        String uuid = listener.getQueueUuid();
        SQSQueue queue = this.provider.getSqsQueue(uuid);
        if (queue == null) {
            Log.warning("No queue for {%s}, aborted", uuid);
            return false;
        }
        this.register(listener, uuid, queue);
        return true;
    }

    @Override
    public boolean unregister(SQSQueueListener listener) {
        if (listener == null) {
            return false;
        }
        Log.info("Unregister SQS listener", new Object[0]);
        String uuid = listener.getQueueUuid();
        SQSQueueMonitor monitor = this.monitors.get(uuid);
        if (monitor == null) {
            Log.warning("No monitor for {%s}, aborted", uuid);
            return false;
        }
        Log.info("Remove listener from monitor for {%s}", uuid);
        if (monitor.remove(listener)) {
            monitor.shutDown();
        }
        if (monitor.isShutDown()) {
            Log.info("Monitor is shut down, remove monitor for {%s}", uuid);
            this.monitors.remove(uuid);
        }
        return true;
    }

    @Override
    public void onConfigurationChanged() {
        Iterator<Map.Entry<String, SQSQueueMonitor>> entries = this.monitors.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SQSQueueMonitor> entry = entries.next();
            this.reconfigure(entries, entry);
        }
    }

    private void register(SQSQueueListener listener, String uuid, SQSQueue queue) {
        SQSQueueMonitor monitor = this.monitors.get(uuid);
        if (monitor == null) {
            Log.info("No monitor exists, creating new monitor for %s", queue);
            monitor = this.factory.createMonitor(this.executor, queue);
            this.monitors.put(uuid, monitor);
        }
        Log.info("Add listener to monitor for %s", queue);
        monitor.add(listener);
    }

    private void reconfigure(Iterator<Map.Entry<String, SQSQueueMonitor>> entries, Map.Entry<String, SQSQueueMonitor> entry) {
        String uuid = entry.getKey();
        SQSQueueMonitor monitor = entry.getValue();
        SQSQueue queue = this.provider.getSqsQueue(uuid);
        if (queue == null) {
            Log.info("Queue {%s} removed, shut down monitor", uuid);
            monitor.shutDown();
            entries.remove();
        } else if (monitor.isShutDown()) {
            Log.info("Monitor for queue {%s} is shut down, restart", uuid);
            this.executor.execute(monitor);
        }
    }
}

