/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.threading;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueListener;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueMonitor;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.net.SQSChannel;
import io.relution.jenkins.scmsqs.util.ThrowIf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class SQSQueueMonitorImpl
implements SQSQueueMonitor {
    private static final String ERROR_WRONG_QUEUE = "The specified listener is associated with another queue.";
    private final ExecutorService executor;
    private final SQSChannel channel;
    private final Object listenersLock = new Object();
    private final List<SQSQueueListener> listeners = new ArrayList<SQSQueueListener>();
    private final AtomicBoolean isRunning = new AtomicBoolean();
    private volatile boolean isShutDown;

    public SQSQueueMonitorImpl(ExecutorService executor, SQSChannel channel) {
        ThrowIf.isNull(executor, "executor");
        ThrowIf.isNull(channel, "channel");
        this.executor = executor;
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(SQSQueueListener listener) {
        ThrowIf.isNull(listener, "listener");
        ThrowIf.notEqual(listener.getQueueUuid(), this.channel.getQueueUuid(), ERROR_WRONG_QUEUE, new Object[0]);
        Object object = this.listenersLock;
        synchronized (object) {
            block4: {
                if (!this.listeners.add(listener) || this.listeners.size() != 1) break block4;
                this.isShutDown = false;
                this.execute();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(SQSQueueListener listener) {
        if (listener == null) {
            return false;
        }
        Object object = this.listenersLock;
        synchronized (object) {
            block5: {
                if (!this.listeners.remove(listener) || !this.listeners.isEmpty()) break block5;
                this.shutDown();
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block9: {
            block8: {
                if (!this.isShutDown) break block8;
                if (this.isRunning.compareAndSet(true, false)) return;
                Log.warning("Monitor for %s already stopped", this.channel);
                return;
            }
            if (this.isRunning.compareAndSet(false, true)) break block9;
            Log.warning("Monitor for %s already started", this.channel);
            if (this.isRunning.compareAndSet(true, false)) return;
            Log.warning("Monitor for %s already stopped", this.channel);
            return;
        }
        try {
            Log.fine("Start synchronous monitor for %s", this.channel);
            this.processMessages();
            this.execute();
        }
        catch (QueueDoesNotExistException e) {
            Log.warning("Queue %s does not exist, monitor stopped", this.channel);
            this.isShutDown = true;
            if (this.isRunning.compareAndSet(true, false)) return;
            Log.warning("Monitor for %s already stopped", this.channel);
            return;
        }
        catch (Exception e) {
            try {
                Log.severe(e, "Unknown error, monitor for queue %s stopped", this.channel);
                this.isShutDown = true;
                if (this.isRunning.compareAndSet(true, false)) return;
            }
            catch (Throwable throwable) {
                if (this.isRunning.compareAndSet(true, false)) throw throwable;
                Log.warning("Monitor for %s already stopped", this.channel);
                throw throwable;
            }
            Log.warning("Monitor for %s already stopped", this.channel);
            return;
        }
        if (this.isRunning.compareAndSet(true, false)) return;
        Log.warning("Monitor for %s already stopped", this.channel);
    }

    @Override
    public void shutDown() {
        Log.info("Shut down monitor for %s", this.channel);
        this.isShutDown = true;
    }

    @Override
    public boolean isShutDown() {
        return this.isShutDown;
    }

    private void execute() {
        if (!this.isShutDown) {
            this.executor.execute(this);
        }
    }

    private void processMessages() {
        List<Message> messages = this.channel.getMessages();
        if (this.isShutDown) {
            return;
        }
        if (this.notifyListeners(messages)) {
            this.channel.deleteMessages(messages);
        }
    }

    private boolean notifyListeners(List<Message> messages) {
        if (messages.isEmpty()) {
            Log.fine("Received no messages from %s", this.channel);
            return false;
        }
        Log.info("Received %d message(s) from %s", messages.size(), this.channel);
        List<SQSQueueListener> listeners = this.getListeners();
        for (SQSQueueListener listener : listeners) {
            listener.handleMessages(messages);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQSQueueListener> getListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            return new ArrayList<SQSQueueListener>(this.listeners);
        }
    }
}

