/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.net;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.net.RequestFactory;
import io.relution.jenkins.scmsqs.net.SQSChannel;
import io.relution.jenkins.scmsqs.util.ThrowIf;
import java.util.Collections;
import java.util.List;

public class SQSChannelImpl
implements SQSChannel {
    private final AmazonSQS sqs;
    private final SQSQueue queue;
    private final RequestFactory factory;
    private int requestCount;

    public SQSChannelImpl(AmazonSQS sqs, SQSQueue queue, RequestFactory factory) {
        ThrowIf.isNull(sqs, "sqs");
        ThrowIf.isNull(queue, "queue");
        ThrowIf.isNull(factory, "factory");
        this.sqs = sqs;
        this.queue = queue;
        this.factory = factory;
    }

    @Override
    public List<Message> getMessages() {
        try {
            this.logRequestCount();
            ReceiveMessageRequest request = this.factory.createReceiveMessageRequest(this.queue);
            ReceiveMessageResult result = this.sqs.receiveMessage(request);
            if (result == null) {
                return Collections.emptyList();
            }
            return result.getMessages();
        }
        catch (AmazonServiceException e) {
            Log.severe(e, "Failed to send receive message request for %s", this.queue);
            return Collections.emptyList();
        }
    }

    @Override
    public void deleteMessages(List<Message> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        DeleteMessageBatchResult result = this.deleteMessageBatch(messages);
        if (result == null) {
            return;
        }
        List failed = result.getFailed();
        List success = result.getSuccessful();
        Log.info("Deleted %d message(s) (%d failed) from %s", success.size(), failed.size(), this.queue);
    }

    @Override
    public String getQueueUuid() {
        return this.queue.getUuid();
    }

    public String toString() {
        return this.queue.toString();
    }

    private void logRequestCount() {
        ++this.requestCount;
        Log.fine("Send receive message request #%d for %s", this.requestCount, this.queue);
    }

    private DeleteMessageBatchResult deleteMessageBatch(List<Message> messages) {
        try {
            DeleteMessageBatchRequest request = this.factory.createDeleteMessageBatchRequest(this.queue, messages);
            Log.info("Send delete request for %d message(s) to %s", messages.size(), this.queue);
            return this.sqs.deleteMessageBatch(request);
        }
        catch (AmazonServiceException e) {
            Log.severe(e, "Delete from %s failed", this.queue);
            return null;
        }
    }
}

