/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.net;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.net.RequestFactory;
import java.util.ArrayList;
import java.util.List;

public class RequestFactoryImpl
implements RequestFactory {
    @Override
    public ReceiveMessageRequest createReceiveMessageRequest(SQSQueue queue) {
        ReceiveMessageRequest request = new ReceiveMessageRequest(queue.getUrl());
        request.setMaxNumberOfMessages(Integer.valueOf(queue.getMaxNumberOfMessages()));
        request.setWaitTimeSeconds(Integer.valueOf(queue.getWaitTimeSeconds()));
        request.setRequestCredentials((AWSCredentials)queue);
        return request;
    }

    @Override
    public DeleteMessageBatchRequest createDeleteMessageBatchRequest(SQSQueue queue, List<Message> messages) {
        ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(messages.size());
        for (Message message : messages) {
            DeleteMessageBatchRequestEntry entry = this.createDeleteMessageBatchRequestEntry(message);
            entries.add(entry);
        }
        DeleteMessageBatchRequest request = new DeleteMessageBatchRequest(queue.getUrl());
        request.setRequestCredentials((AWSCredentials)queue);
        request.setEntries(entries);
        return request;
    }

    private DeleteMessageBatchRequestEntry createDeleteMessageBatchRequestEntry(Message message) {
        DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry();
        entry.setReceiptHandle(message.getReceiptHandle());
        entry.setId(message.getMessageId());
        return entry;
    }
}

