/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.model.entities.codecommit;

import io.relution.jenkins.scmsqs.interfaces.Event;
import io.relution.jenkins.scmsqs.model.entities.codecommit.Record;
import io.relution.jenkins.scmsqs.model.entities.codecommit.Reference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.URIish;

public class CodeCommitEvent
implements Event {
    private static final String HOST = "git-codecommit.%s.amazonaws.com";
    private static final String PATH = "/v1/repos/%s";
    private final String host;
    private final String path;
    private final String branch;

    public CodeCommitEvent(Record record, Reference reference) {
        String arn = record.getEventSourceARN();
        String[] tokens = arn.split(":", 6);
        this.host = String.format(HOST, tokens[3]);
        this.path = String.format(PATH, tokens[5]);
        String name = reference.getName();
        this.branch = StringUtils.stripStart((String)name, (String)"refs/");
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public boolean isMatch(URIish uri) {
        if (uri == null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.host, (CharSequence)uri.getHost())) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.path, (CharSequence)uri.getPath());
    }
}

