/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.model;

import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import io.relution.jenkins.scmsqs.interfaces.Event;
import io.relution.jenkins.scmsqs.interfaces.EventTriggerMatcher;
import java.util.List;
import jenkins.model.Jenkins;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.multiplescms.MultiSCM;

public class EventTriggerMatcherImpl
implements EventTriggerMatcher {
    @Override
    public boolean matches(List<Event> events, SCM scm) {
        if (events == null || scm == null) {
            return false;
        }
        for (Event event : events) {
            if (!this.matches(event, scm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Event event, SCM scm) {
        if (event == null || scm == null) {
            return false;
        }
        if (this.isGitScm(scm)) {
            return this.matchesGitSCM(event, (GitSCM)scm);
        }
        if (this.isMultiScm(scm)) {
            return this.matchesMultiSCM(event, (MultiSCM)scm);
        }
        return false;
    }

    private boolean matchesGitSCM(Event event, GitSCM scm) {
        List configs = scm.getRepositories();
        List branches = scm.getBranches();
        return this.matchesConfigs(event, configs) && this.matchesBranches(event, branches);
    }

    private boolean matchesMultiSCM(Event event, MultiSCM multiSCM) {
        List scms = multiSCM.getConfiguredSCMs();
        for (SCM scm : scms) {
            if (!this.matches(event, scm)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesBranches(Event event, List<BranchSpec> branches) {
        for (BranchSpec branch : branches) {
            if (!this.matchesBranch(event, branch)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesBranch(Event event, BranchSpec branch) {
        return branch.matches(event.getBranch());
    }

    private boolean matchesConfigs(Event event, List<RemoteConfig> configs) {
        for (RemoteConfig config : configs) {
            if (!this.matchesConfig(event, config)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesConfig(Event event, RemoteConfig config) {
        for (URIish uri : config.getURIs()) {
            if (!event.isMatch(uri)) continue;
            return true;
        }
        return false;
    }

    private boolean isMultiScm(SCM scm) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null || scm == null) {
            return false;
        }
        return jenkins.getPlugin("multiple-scms") != null && scm instanceof MultiSCM;
    }

    private boolean isGitScm(SCM scm) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null || scm == null) {
            return false;
        }
        return jenkins.getPlugin("git") != null && scm instanceof GitSCM;
    }
}

