/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.model;

import com.amazonaws.services.sqs.model.Message;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.relution.jenkins.scmsqs.interfaces.Event;
import io.relution.jenkins.scmsqs.interfaces.MessageParser;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.model.entities.codecommit.CodeCommit;
import io.relution.jenkins.scmsqs.model.entities.codecommit.CodeCommitEvent;
import io.relution.jenkins.scmsqs.model.entities.codecommit.MessageBody;
import io.relution.jenkins.scmsqs.model.entities.codecommit.Record;
import io.relution.jenkins.scmsqs.model.entities.codecommit.Records;
import io.relution.jenkins.scmsqs.model.entities.codecommit.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CodeCommitMessageParser
implements MessageParser {
    private static final String EVENT_SOURCE_CODECOMMIT = "aws:codecommit";
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public List<Event> parseMessage(Message message) {
        MessageBody body = (MessageBody)this.gson.fromJson(message.getBody(), MessageBody.class);
        Log.info("Got message with subject: %s", body.getSubject());
        String json = body.getMessage();
        if (StringUtils.isEmpty((CharSequence)json)) {
            Log.warning("Message contains no text", new Object[0]);
            return Collections.emptyList();
        }
        if (!json.startsWith("{") || !json.endsWith("}")) {
            Log.warning("Message text is no JSON", new Object[0]);
            return Collections.emptyList();
        }
        return this.parseRecords(json);
    }

    private List<Event> parseRecords(String json) {
        Records records = (Records)this.gson.fromJson(json, Records.class);
        ArrayList<Event> events = new ArrayList<Event>(records.size());
        for (Record record : records) {
            this.parseEvents(events, record);
        }
        return events;
    }

    private void parseEvents(List<Event> events, Record record) {
        if (!this.isCodeCommitEvent(record)) {
            return;
        }
        CodeCommit codeCommit = record.getCodeCommit();
        for (Reference reference : codeCommit.getReferences()) {
            CodeCommitEvent event = new CodeCommitEvent(record, reference);
            events.add(event);
        }
    }

    private boolean isCodeCommitEvent(Record record) {
        return StringUtils.equals((CharSequence)EVENT_SOURCE_CODECOMMIT, (CharSequence)record.getEventSource());
    }
}

