/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.factories;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.google.inject.Inject;
import io.relution.jenkins.scmsqs.interfaces.SQSFactory;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueMonitor;
import io.relution.jenkins.scmsqs.net.RequestFactory;
import io.relution.jenkins.scmsqs.net.SQSChannel;
import io.relution.jenkins.scmsqs.net.SQSChannelImpl;
import io.relution.jenkins.scmsqs.threading.SQSQueueMonitorImpl;
import java.util.concurrent.ExecutorService;

public class SQSFactoryImpl
implements SQSFactory {
    private final ExecutorService executor;
    private final RequestFactory factory;

    @Inject
    public SQSFactoryImpl(ExecutorService executor, RequestFactory factory) {
        this.executor = executor;
        this.factory = factory;
    }

    @Override
    public AmazonSQS createSQS(SQSQueue queue) {
        ClientConfiguration clientConfiguration = this.getClientConfiguration(queue);
        AmazonSQSClient sqs = new AmazonSQSClient((AWSCredentials)queue, clientConfiguration);
        if (queue.getEndpoint() != null) {
            sqs.setEndpoint(queue.getEndpoint());
        }
        return sqs;
    }

    @Override
    public AmazonSQSAsync createSQSAsync(SQSQueue queue) {
        ClientConfiguration clientConfiguration = this.getClientConfiguration(queue);
        AmazonSQSAsyncClient sqsAsync = new AmazonSQSAsyncClient((AWSCredentials)queue, clientConfiguration, this.executor);
        if (queue.getEndpoint() != null) {
            sqsAsync.setEndpoint(queue.getEndpoint());
        }
        QueueBufferConfig queueBufferConfig = this.getQueueBufferConfig(queue);
        AmazonSQSBufferedAsyncClient sqsBufferedAsync = new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)sqsAsync, queueBufferConfig);
        return sqsBufferedAsync;
    }

    @Override
    public SQSChannel createChannel(SQSQueue queue) {
        AmazonSQS sqs = this.createSQS(queue);
        return new SQSChannelImpl(sqs, queue, this.factory);
    }

    @Override
    public SQSQueueMonitor createMonitor(ExecutorService executor, SQSQueue queue) {
        SQSChannel channel = this.createChannel(queue);
        return new SQSQueueMonitorImpl(executor, channel);
    }

    private ClientConfiguration getClientConfiguration(SQSQueue queue) {
        ClientConfiguration config = new ClientConfiguration();
        return config;
    }

    private QueueBufferConfig getQueueBufferConfig(SQSQueue queue) {
        QueueBufferConfig config = new QueueBufferConfig();
        config.setLongPollWaitTimeoutSeconds(queue.getWaitTimeSeconds());
        config.setLongPoll(true);
        return config;
    }
}

