/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs.factories;

import com.google.inject.Inject;
import io.relution.jenkins.scmsqs.interfaces.ExecutorFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorFactoryImpl
implements ExecutorFactory {
    private static final int CORE_POOL_SIZE = 10;
    private static final int MAXIMUM_POOL_SIZE = 50;
    private static final int KEEP_ALIVE_TIME = 5;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.MINUTES;
    final ThreadFactory threadFactory;

    @Inject
    public ExecutorFactoryImpl(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadPoolExecutor createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 50, 5L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>(), this.threadFactory);
        executor.allowCoreThreadTimeOut(false);
        return executor;
    }
}

