/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.relution.jenkins.scmsqs.Context;
import io.relution.jenkins.scmsqs.interfaces.SQSFactory;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.sqstriggerqueue.Messages;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SQSTriggerQueue
extends AbstractDescribableImpl<SQSTriggerQueue>
implements SQSQueue {
    public static final Pattern SQS_URL_PATTERN = Pattern.compile("^(?:http(?:s)?://)?(?<endpoint>sqs\\..+?\\.amazonaws\\.com)/(?<id>.+?)/(?<name>.*)$");
    public static final Pattern CODECOMMIT_URL_PATTERN = Pattern.compile("^(?:http(?:s)?://)?git-codecommit\\.(?<region>.+?)\\.amazonaws\\.com/v1/repos/(?<name>.*)$");
    private final String uuid;
    private final String nameOrUrl;
    private final String accessKey;
    private final Secret secretKey;
    private final int waitTimeSeconds;
    private final int maxNumberOfMessages;
    private String url;
    private final String name;
    private final String endpoint;
    private transient SQSFactory factory;
    private transient AmazonSQS sqs;
    private transient String s;

    @DataBoundConstructor
    public SQSTriggerQueue(String uuid, String nameOrUrl, String accessKey, Secret secretKey, int waitTimeSeconds, int maxNumberOfMessages) {
        this.uuid = StringUtils.isBlank((CharSequence)uuid) ? UUID.randomUUID().toString() : uuid;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.nameOrUrl = nameOrUrl;
        this.waitTimeSeconds = this.limit(waitTimeSeconds, 1, 20, 20);
        this.maxNumberOfMessages = this.limit(maxNumberOfMessages, 1, 10, 10);
        Matcher sqsUrlMatcher = SQS_URL_PATTERN.matcher(nameOrUrl);
        if (sqsUrlMatcher.matches()) {
            this.url = nameOrUrl;
            this.name = sqsUrlMatcher.group("name");
            this.endpoint = sqsUrlMatcher.group("endpoint");
        } else {
            this.name = nameOrUrl;
            this.endpoint = null;
        }
        Log.info("Create new SQSTriggerQueue(%s, %s, %s)", this.uuid, nameOrUrl, accessKey);
    }

    public AmazonSQS getSQSClient() {
        if (this.sqs == null) {
            this.sqs = this.getFactory().createSQSAsync(this);
        }
        return this.sqs;
    }

    @Inject
    public void setFactory(SQSFactory factory) {
        this.factory = factory;
    }

    public SQSFactory getFactory() {
        if (this.factory == null) {
            Context.injector().injectMembers((Object)this);
        }
        return this.factory;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public String getNameOrUrl() {
        return this.nameOrUrl;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Secret getSecretKey() {
        return this.secretKey;
    }

    @Override
    public int getWaitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    @Override
    public int getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            AmazonSQS client = this.getSQSClient();
            GetQueueUrlResult result = client.getQueueUrl(this.name);
            this.url = result.getQueueUrl();
        }
        return this.url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    public String getAWSSecretKey() {
        if (this.secretKey == null) {
            return null;
        }
        return this.secretKey.getPlainText();
    }

    @Override
    public boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getAWSAccessKeyId())) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)this.getAWSSecretKey());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQSTriggerQueue)) {
            return false;
        }
        SQSTriggerQueue other = (SQSTriggerQueue)obj;
        return this.uuid.equals(other.uuid);
    }

    public String toString() {
        if (this.s == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            if (!StringUtils.isBlank((CharSequence)this.endpoint)) {
                sb.append(" (");
                sb.append(this.endpoint);
                sb.append(")");
            }
            sb.append(" {");
            sb.append(this.uuid);
            sb.append("}");
            this.s = sb.toString();
        }
        return this.s;
    }

    private int limit(int value, int min, int max, int fallbackValue) {
        if (value < min || value > max) {
            return fallbackValue;
        }
        return value;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SQSTriggerQueue> {
        public String getDisplayName() {
            return Messages.displayName();
        }

        public FormValidation doCheckNameOrUrl(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.warning((String)Messages.warningUrl());
            }
            Matcher sqsUrlMatcher = SQS_URL_PATTERN.matcher(value);
            if (sqsUrlMatcher.matches()) {
                String name = sqsUrlMatcher.group("name");
                return FormValidation.ok((String)Messages.infoUrlSqs(), (Object[])new Object[]{name});
            }
            Matcher ccUrlMatcher = CODECOMMIT_URL_PATTERN.matcher(value);
            if (ccUrlMatcher.matches()) {
                return FormValidation.error((String)Messages.errorUrlCodecommit());
            }
            if (StringUtils.startsWith((CharSequence)value, (CharSequence)"http://") || StringUtils.startsWith((CharSequence)value, (CharSequence)"https://")) {
                return FormValidation.error((String)Messages.errorUrlUnknown());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWaitTimeSeconds(@QueryParameter String value) {
            return this.validateNumber(value, 1, 20, Messages.errorWaitTimeSeconds());
        }

        public FormValidation doCheckMaxNumberOfMessage(@QueryParameter String value) {
            return this.validateNumber(value, 1, 10, Messages.errorMaxNumberOfMessages());
        }

        public FormValidation doValidate(@QueryParameter String uuid, @QueryParameter String nameOrUrl, @QueryParameter String accessKey, @QueryParameter Secret secretKey) throws IOException {
            try {
                SQSTriggerQueue queue = new SQSTriggerQueue(uuid, nameOrUrl, accessKey, secretKey, 0, 0);
                if (StringUtils.isBlank((CharSequence)queue.getName())) {
                    return FormValidation.warning((String)"Name or URL of the queue must be set.");
                }
                if (StringUtils.isEmpty((CharSequence)queue.getAWSAccessKeyId())) {
                    return FormValidation.warning((String)"AWS access key ID must be set.");
                }
                if (StringUtils.isEmpty((CharSequence)queue.getAWSSecretKey())) {
                    return FormValidation.warning((String)"AWS secret key must be set.");
                }
                AmazonSQS client = queue.getSQSClient();
                if (client == null) {
                    return FormValidation.error((String)"Failed to create SQS client");
                }
                String queueName = queue.getName();
                GetQueueUrlResult result = client.getQueueUrl(queueName);
                if (result == null) {
                    return FormValidation.error((String)"Failed to get SQS client queue URL");
                }
                String url = result.getQueueUrl();
                return FormValidation.ok((String)"Access to %s successful\n(%s)", (Object[])new Object[]{queue.getName(), url});
            }
            catch (AmazonServiceException ase) {
                return FormValidation.error((Throwable)ase, (String)ase.getMessage());
            }
            catch (RuntimeException ex) {
                return FormValidation.error((Throwable)ex, (String)"Error validating SQS access");
            }
        }

        private FormValidation validateNumber(String value, int min, int max, String message) {
            try {
                if (StringUtils.isBlank((CharSequence)value)) {
                    return FormValidation.error((String)message);
                }
                int number = Integer.parseInt(value);
                if (number < min || number > max) {
                    return FormValidation.error((String)message);
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)message);
            }
        }
    }
}

